// **************************************************************************
// *				 Sporting Clays for the Playstation						*
// *					   (C) 1999 Charles Doty                           	*
// *	 Sound Source file contains sound playing and loading code			*
// **************************************************************************

#include <sgl.h>
#include <sl_def.h>
#include <sddrvs.dat>

#include "sound.h"

BOOL	SoundsLoaded;
PCM     PcmData;

DWORD SoundInitialize()
{
    char    SoundMap[]  = {0xff, 0xff};

    SoundsLoaded = FALSE;

    slInitSound(sddrvstsk, sizeof(sddrvstsk), (Uint8 *)SoundMap,
        sizeof(SoundMap));

	return ERR_NOERROR;
}

DWORD LoadSounds(char *sound)
{
//    char filename[FILENAMELEN];

	SoundsLoaded = TRUE;

	return ERR_NOERROR;
}

DWORD PlaySound(Uint8 *sound, short size, short pan)
{
    short   loop;

	if (FALSE == SoundsLoaded)
	{
#ifdef DEBUG
       slPrint("Sounds not loaded prior to playing a sound in PlaySound.\n",
        slLocate(9,2));
#endif

		return ERR_PLAYERROR;
	}

    for (loop = 0; loop < MAXSOUNDCHANNELS; loop++)
    {
        PcmData.mode        = _Mono | _PCM8Bit;
        PcmData.channel     = loop;
        PcmData.level       = 127;
        PcmData.pan         = pan;
        PcmData.pitch       = 29056;
        PcmData.eflevelR    = 0;
        PcmData.efselectR   = 0;
        PcmData.eflevelL    = 0;
        PcmData.efselectR   = 0;

        if (FALSE == slPCMStat(&PcmData))
        {
            break;
        }
    }

    if (loop < MAXSOUNDCHANNELS)
    {
        slPCMOn(&PcmData, sound, size);
    }

    else
    {
        return  ERR_PLAYERROR;
    }

    return ERR_NOERROR;
}
