// **************************************************************************
// *				 Sporting Clays for the Playstation						*
// *					   (C) 1999 Charles Doty                          	*
// *	 	   3D Header Source file contains 3D related code				*
// **************************************************************************

#ifndef __SCENE3D_H
#define __SCENE3D_H

#include "defines.h"

#define MAXPOLYGONS 200                     // maximum amount of polygons
#define CLAYSIZE    8                       // Size of clay object

typedef struct
{
    FIXED   v0, v1, v2;
} Vertices;

typedef struct
{
    XPDATA  *Primatives;
} ObjectDesc;

typedef struct
{
    ANGLE           Rotation[XYZ];          // Rotation
    FIXED           Position[XYZ];          // Position
    FIXED           Scale[XYZ];             // Scale
    ObjectDesc      Object[MAXFRAMES];		// Object
	BOOL			Used;					// Is object in use?
	long			CurrentFrame;			// Current Frame
} Object3D;

DWORD Scene3DInitialize();
  // Initializes the 3D Scene

DWORD AddObject(XPDATA *object, WORD *ObjectID, POS *position, ROT *rotation,
    SCALE *scale);
  // Adds object to scene

DWORD AddAnimation(XPDATA *object, WORD ObjectID, long frame);
  // Adds and animation frame to the model

DWORD RemoveObject(WORD ObjectID);
  // Removes an object from the list

DWORD MoveObject(WORD ObjectID, POS *position);
  // Changes the position of a 3D Object

DWORD RotateObject(WORD ObjectID, ROT *rotation);
  // Changes the rotation of a 3D Object

DWORD SetObjectFrame(WORD ObjectID, long frame);
  // Sets objects current frame

BOOL CheckIntersection(WORD ObjectID, short x, short y, short range, short *distance, short *xdir,
	short *ydir);
  // Checks object intersection with a point

BOOL CheckFloor(WORD ObjectID, short y);
  // Checks object intersection with scene defined floor

BOOL CheckScreen(WORD ObjectID);
  // Checks if object has left the screen

DWORD Render(void);
  // Renders the 3D Objects

DWORD LoadTIM(u_long *TIM);
  // Loads TIM related to 3d graphics

#endif
