// **************************************************************************
// *				 Sporting Clays for the Playstation						*
// *					   (C) 1999 Charles Doty                           	*
// *	 		   Input Source file contains input code					*
// **************************************************************************

#ifndef __INPUT_H
#define __INPUT_H

#include <sgl.h>

#include "defines.h"

#define GUNTYPE             0x0A
#define MAXBUFFERSHOTS		20	// Maximum shots in the gun shot buffer

#define MOUSE_LEFTBUTTON	0x0800
#define MOUSE_RIGHTBUTTON	0x0400
#define PAD_SELECT			0x0001
#define PAD_START			0x0008
#define PAD_UP				0x0010
#define PAD_DOWN			0x0040
#define PAD_LEFT			0x0080
#define PAD_RIGHT			0x0020
#define PAD_X				0x4000

typedef struct
{
	WORD			Buttons;	// Buttons on the gun
	BYTE			X;			// X position of the gun
	BYTE			Section;	// The section the gun is in
	BYTE			Y;			// Y position of the gun
	BYTE			Pad;		// Pad ID.
} Gun;

typedef struct
{
	WORD			Buttons;	// Buttons on the mouse
    short           X;          // X position of the mouse
    short           Y;          // Y position of the mouse
} MouseStatus;

typedef struct
{
	DWORD			Type;		// Type of controller
	DWORD			Buttons;	// Button flags
	DWORD			Controller;	// Direction flags for the controller
    short           X;          // Relative x position of the controller
    short           Y;          // Relative y position of the controller
} InputStruct;

DWORD InputInitialize();
  // Initialize input system.

DWORD ReadInput(InputStruct *Input, DWORD gun);
  // Reads input

DWORD SetPadMoveValues(short x, short y);
  // Sets pad movement resolution

DWORD SetMouseLimits(short x1, short y1, short x2, short y2);
  // Sets the area that the mouse can move in.

DWORD SetInputMousePosition(short x, short y);
  // Sets mouse position

void TriggerFunction();
  // Gun callback
  
DWORD CloseCurrentDevice();
  // Marks the controller as no longer used

#endif
