// **************************************************************************
// *				 Sporting Clays for the Playstation						*
// *					   (C) 1999 Charles Doty                           	*
// *	 		   Input Source file contains input code					*
// **************************************************************************

#include <sgl.h>

#include "input.h"

#define MOUSESCALEX			3
#define MOUSESCALEY         4
#define MOUSESPEED			2

BOOL    Fired       = TRUE; // Should a shot be checked for?
BOOL    GunUsed     = FALSE;// Is gun used?
BOOL    MouseUsed   = FALSE;// Is mouse used?
BOOL    PadUsed     = FALSE;// Is pad used?
BOOL    CheckGun    = FALSE;// Check gun
short   PadXValue   = 1;    // X Value of Pad movement
short   PadYValue   = 1;    // Y Value of Pad movement
RECT    MouseLimits;        // Limits of the mouse movement
MouseStatus Mouse;          // Current mouse x position

extern  Sint8        SynchCount;
extern  Uint16       VDP2_EXTEN;

DWORD InputInitialize()
{
    VDP2_EXTEN  = 0x0200;
    CheckGun    = FALSE;

	slGetStatus();
    slIntFunction(TriggerFunction);

    MouseLimits.x   = -(SCREENWIDTH / 2);
    MouseLimits.y   = -(SCREENHEIGHT / 2);
    MouseLimits.w   = SCREENWIDTH / 2;
    MouseLimits.h   = SCREENHEIGHT / 2;
    Mouse.X         = 0;
    Mouse.Y         = 0;

	return ERR_NOERROR;
}

DWORD ReadInput(InputStruct *Input, DWORD gun)
{
    static      Uint8   ID  = PER_ID_StnShooting;
    PerPoint    *Point;

	Input->Buttons	= BUT_NONE;
	Input->Type		= CON_NONE;

    if (FALSE == slCheckIntBackSet())
    {
        if (TRUE == CheckGun)
        {
            slSetPortDir1(0x00);
            slSetPortData1(0x7f);
            slSetPortSelect1(SMPC_SH2_DIRECT);
        }

        else
        {
            slSetPortSelect1(SMPC_CONTROL);
            slSetPortExt1(SMPC_EXL_DIS);
        }

        slGetStatus();

        return;
    }

    Point   = (PerPoint *)(&(Smpc_Peripheral[0]));

    if ((ID != PER_ID_NotConnect) && ((GUNTYPE | 0xf0) == Point->id))
    {
        CheckGun    = TRUE;

        slIntBackCancel();
    }

    ID      = Point->id;

    if (Point->data != 0xffff)
    {
        if (PER_ID_StnShooting == Point->id)
        {
            CloseCurrentDevice();
            GunUsed     = TRUE;
            Input->Type = CON_GUN;

            Input->X    = Point->x /2 - SCREENWIDTH / 2;
            Input->Y    = Point->y - SCREENHEIGHT / 2;
        }

        else
        {
            if (PER_ID_StnPad == Point->id)
            {
                CloseCurrentDevice();
                PadUsed     = TRUE;
                Input->Type = CON_PAD;
                
                if (0 == (Point->data & PER_DGT_KU))
                {
                    Mouse.Y         -= PadYValue * MOUSESCALEY;
                }

                else if (0 == (Point->data & PER_DGT_KD))
                {
                    Mouse.Y         += PadYValue * MOUSESCALEY;
                }

                if (0 == (Point->data & PER_DGT_KL))
                {
                    Mouse.X         -= (PadXValue * MOUSESCALEX);
                }

                else if (0 == (Point->data & PER_DGT_KR))
                {
                    Mouse.X         += (PadXValue * MOUSESCALEX);
                }

                if (Mouse.X < MouseLimits.x)
                {
                    Mouse.X = MouseLimits.x;
                }       

                else if (Mouse.X > MouseLimits.w)
                {
                    Mouse.X = MouseLimits.w;
                }
    
                if (Mouse.Y < MouseLimits.y)
                {
                    Mouse.Y = MouseLimits.y;
                }

                else if (Mouse.Y > MouseLimits.h)
                {
                    Mouse.Y = MouseLimits.h;
                }

                Input->X    = Mouse.X / MOUSESCALEX;
                Input->Y    = Mouse.Y / MOUSESCALEY;
            }

            else if (PER_ID_StnMouse == Point->id)
            {
                CloseCurrentDevice();
                MouseUsed   = TRUE;

               Input->Type = CON_MOUSE;
            }
        }

        if (0 == (Point->data & PER_DGT_ST))
        {
            Input->Buttons  |= BUT_START;
        }

        if (0 == (Point->data & PER_DGT_TA))
        {
            if (TRUE == Fired)
            {
                Input->Type     = CON_PAD;
                Input->Buttons  |= BUT_TRIGGER;
            
                Fired = FALSE;
            }
        }

        else
        {
            Fired = TRUE;
        }
    }

    else
    {
        Fired   = TRUE;
    }

    return ERR_NOERROR;
}

DWORD SetPadMoveValues(short x, short y)
{
	PadXValue = x;
	PadYValue = y;

	return ERR_NOERROR;
}

DWORD SetMouseLimits(short x1, short y1, short x2, short y2)
{
    MouseLimits.x   = (x1 - SCREENWIDTH / 2) * MOUSESCALEX;
    MouseLimits.y   = (y1 - SCREENHEIGHT / 2) * MOUSESCALEY;
    MouseLimits.w   = (x2 - SCREENWIDTH / 2) * MOUSESCALEX;
    MouseLimits.h   = (y2 - SCREENHEIGHT / 2) * MOUSESCALEY;

    return ERR_NOERROR;
}

DWORD SetInputMousePosition(short x, short y)
{
    Mouse.X         = x * MOUSESCALEX;
    Mouse.Y         = y * MOUSESCALEY;

	return ERR_NOERROR;
}

void TriggerFunction()
{
    PerPoint    *Point;
    Uint8       PadData0;
    Uint8       PadData1;
    Uint8       ID;

    if (TRUE == SynchCount)
    {
        return;
    }

    Point   = (PerPoint *)(&(Smpc_Peripheral[0]));

    if (TRUE == CheckGun && PER_ID_StnShooting == Point->id)
    {
        slSetPortDir1(0x40);
        PadData1    = slGetPortData1();

        slSetPortDir1(0x00);
        PadData0    = slGetPortData1();

        PadData1    = (PadData1 & 0x0a) | ((PadData1 & 0x05) << 1);
        ID          = (PadData1 & 0x08) | ((PadData1 & 0x02) << 1);
        PadData0    = (PadData0 & 0x05) | ((PadData0 & 0x0a) >> 1);
        ID          |= (PadData0 & 0x01) | ((PadData0 & 0x04) >> 1);

        if (ID != GUNTYPE)
        {
            CheckGun    = FALSE;

            slIntBackCancel();
        }
    }    
}

DWORD CloseCurrentDevice()
{
	if (TRUE == PadUsed)
	{
		PadUsed		= FALSE;
	}

	if (TRUE == MouseUsed)
	{
		MouseUsed	= FALSE;
	}

	if (TRUE == GunUsed)
	{
		GunUsed 	= FALSE;
	}

	return ERR_NOERROR;
}
