// **************************************************************************
// *				 Sporting Clays for the Playstation						*
// *					   (C) 1999 Charles Doty                           	*
// *	 		Game Header file contains game related code					*
// **************************************************************************

#ifndef __GAME_H
#define	__GAME_H

#include <sgl.h>

#include "scene.h"

typedef struct
{
	WORD			ObjectID;	// ID of object in Scene3D
    POS             Position;   // Object position
    POS             Init;       // Object Initial position
    ROT             Rotation;   // Object rotation
    SCALE           Scale;      // Object scale
	float			Velx;		// Object velocity x
	float			Vely;		// Object velocity y
	float			Velz;		// Object velocity z
	short			Speed;		// Object speed
	short			Delay;		// Object delay
	long			AngleY;		// Y angle of launch
	long			AngleZ;		// Z angle of launch
	BOOL			Rabbit;		// Is this a rabbit?
	BOOL			Remove;		// Remove object when the ground is hit?
	BOOL			Water;		// Will the object hit water?
	BOOL			Hit;		// Was Object Hit?
	BOOL			Flying;		// Is the object flying
} Clay;

DWORD GameInitialize();
  // Initialize game

DWORD Run(WORD scene);
  // Runs game

DWORD LoadScene(WORD scene, BOOL Load);
  // Loads scene description from disk

DWORD AnimateClay(short clay);
  // Calculates the clays flight path

DWORD ReadModel(DWORD Model, PDATA *address);
  // Read a S3D based on a model name

DWORD AddTIM(char *name);
  // Adds TIM to VRAM

BOOL CheckHit(short clay);
  // Checks if a specified clay was hit.

DWORD PrintScores();
  // Prints the results of the round.

DWORD WaitForStart(BOOL PlayPull);
  // Prints message, waits for start

#endif
