// **************************************************************************
// *                    Sporting Clays for the Saturn                       *
// *					   (C) 1999 Charles Doty                           	*
// *	 		 Game Source file contains game related code				*
// **************************************************************************

#include "game.h"
#include "input.h"

#define MAXSCENES       3
#define MAXROUNDS       5
#define RANGE           10
#define INNERRANGE      2

#define MAXSOUNDS       3
#define MOUSESIZE       16
#define RABBITMULTIPLY	1.0

Clay        Clays[MAXOBJECTS];
XPDATA      ClayModel[MAXFRAMES][MAXOBJECTS];
WORD		NumClays;
WORD		ClaysHit[MAXPLAYERS];
WORD		ClaysTotal[MAXPLAYERS];
WORD 		Player;
char		Image[FILENAMELEN];
short       Shots;
short		Floor;
short		ZLimit;								// ZLimit to consider clay hitting the ground. Scene specific.
short		ZOffscreen;							// ZLimit to consider clay Offscreen. Scene specific.
BOOL		OnReport;
BOOL		Shot[2];							// Draw shot (miss) 1/2
float		Flight[2];
float		Flight2[2];
SceneStruct *Scene;
WORD		NumRounds;
InputStruct	Input;

extern char     SubDir[FILENAMELEN];
extern BYTE     Scenes1[];
extern BYTE     Scenes2[];
extern BYTE     Scenes3[];
extern ATTR     OrangeAttributes[];
extern ATTR     WhiteAttributes[];
extern ATTR     GreyAttributes[];
extern POINT    ClayPoints[];
extern POLYGON  ClayPolygons[];
extern POINT    HitPoints[];
extern POLYGON  HitPolygons[];
extern POINT    ChipPoints[];
extern POLYGON  ChipPolygons[];
extern Uint32   ClayNumPoints;
extern Uint32   ClayNumPolygons;
extern Uint32   HitNumPoints;
extern Uint32   HitNumPolygons;
extern Uint32   ChipNumPoints;
extern Uint32   ChipNumPolygons;

extern  Uint8   GunSound[];
extern  Uint32  GunSoundSize;
extern  Uint8   PullSound[];
extern  Uint32  PullSoundSize;
extern  Uint8   LaunchSound[];
extern  Uint32  LaunchSoundSize;
extern  Uint8   EmptySound[];
extern  Uint32  EmptySoundSize;
extern  Uint8   SplashSound[];
extern  Uint32  SplashSoundSize;
extern  Uint8   Hit1Sound[];
extern  Uint32  Hit1SoundSize;
extern  Uint8   Hit2Sound[];
extern  Uint32  Hit2SoundSize;
extern  Uint8   Hit3Sound[];
extern  Uint32  Hit3SoundSize;
extern  Uint8   Miss1Sound[];
extern  Uint32  Miss1SoundSize;
extern  Uint8   Miss2Sound[];
extern  Uint32  Miss2SoundSize;
extern  Uint8   Miss3Sound[];
extern  Uint32  Miss3SoundSize;

DWORD GameInitialize()
{
/*
	char 	filename[FILENAMELEN];

    if (ReadModel((Uint32 *)TMDADDRESS1, TRUE) != ERR_NOERROR)
	{
		return ERR_INITERROR;
	}

	if (ReadModel("grey", (u_long *)TMDADDRESS2, TRUE) != ERR_NOERROR)
	{
		return ERR_INITERROR;
	}

	if (ReadModel("orange", (u_long *)TMDADDRESS3, TRUE) != ERR_NOERROR)
	{
		return ERR_INITERROR;
	}

	if (ReadModel("whitehit", (u_long *)TMDADDRESS4, FALSE) != ERR_NOERROR)
	{
		return ERR_INITERROR;
	}

	if (ReadModel("greyhit", (u_long *)TMDADDRESS5, FALSE) != ERR_NOERROR)
	{
		return ERR_INITERROR;
	}

	if (ReadModel("oranghit", (u_long *)TMDADDRESS6, FALSE) != ERR_NOERROR)
	{
		return ERR_INITERROR;
	}

	if (ReadModel("whiteedg", (u_long *)TMDADDRESS7, FALSE) != ERR_NOERROR)
	{
		return ERR_INITERROR;
	}

	if (ReadModel("greyedg", (u_long *)TMDADDRESS8, FALSE) != ERR_NOERROR)
	{
		return ERR_INITERROR;
	}

	if (ReadModel("orangedg", (u_long *)TMDADDRESS9, FALSE) != ERR_NOERROR)
	{
		return ERR_INITERROR;
	}
*/

    LoadShot(0, 0);
    LoadShot(0, 1);

/*
	strcpy(filename, DIRECTORY);
	strcat(filename, "cursor.tim");

	if (ERR_FILEERROR == FileRead(filename, TIMADDRESS))
	{
        return ERR_FILEERROR;
    }
*/

    LoadMouse(0);

	SetMouseLimits(MOUSESIZE / 2, MOUSESIZE / 2, SCREENWIDTH - MOUSESIZE / 2,
        SCREENHEIGHT - MOUSESIZE / 2);

	LoadSounds("clays");

	return ERR_NOERROR;
}

DWORD Run(WORD scene)
{
	char	filename[80];
    short	sound;
    WORD	loop;

	NumRounds 	= 0;
    Input.X     = 0;
    Input.Y     = 0;

	for (loop = 0; loop < MAXPLAYERS; loop++)
	{
		ClaysHit[loop] = 0;
	}

	for (loop = 0; loop < MAXPLAYERS; loop++)
	{
		ClaysTotal[loop] = 0;
	}

	Player	 = 0;

	SetInputMousePosition(Input.X, Input.Y);
	SetMousePosition(Input.X - MOUSESIZE / 2, Input.Y - MOUSESIZE / 2);
    SetPadMoveValues(4, 4);

    DrawTextString("SPORTING CLAYS.", 3, 3);
    DrawTextString("BY CHARLES DOTY.", 2, 4);
    DrawTextString("CDOTY@NETZERO.NET", 1, 5);

/*
    sprintf(filename, "%s%s%s", DIRECTORY, "00\\", "scene1.tim");

    if (ERR_FILEERROR == FileRead(filename, TIMADDRESS))
    {
        return ERR_INITERROR;
    }
*/

    // Loads Scene
    LoadPicture(scene);

    WaitForStart(FALSE);

    // Loads Scene
	LoadScene(scene, TRUE);
	// Flip display buffers

	while (1)
	{
        ReadInput(&Input, 0);

		if (Input.Type != CON_NONE)
		{
            if (CON_MOUSE == Input.Type || CON_PAD == Input.Type)
			{
				SetMousePosition(Input.X - MOUSESIZE / 2, Input.Y - MOUSESIZE / 2);
			}

			if ((BUT_TRIGGER & Input.Buttons) != 0)
			{
				if (Shots < 2)
				{
                    PlaySound(GunSound, GunSoundSize, 0);

                    if (Clays[0].Position.z <= Clays[1].Position.z)
					{                
						if (FALSE == CheckHit(0))
						{
							if (FALSE == CheckHit(1))
							{
								Shot[Shots] = TRUE;
								SetShotPosition(Input.X - SHOTSIZE / 2, Input.Y - SHOTSIZE / 2,
									Shots);

								sound = rand() % MAXSOUNDS;

                                switch (sound)
                                {
                                    case 0:
                                        PlaySound(Miss1Sound, Miss1SoundSize, 0);

                                        break;

                                    case 1:
                                        PlaySound(Miss2Sound, Miss2SoundSize, 0);

                                        break;

                                    case 2:          
                                        PlaySound(Miss3Sound, Miss3SoundSize, 0);

                                        break;
                                }
							}
						}
					}

					else
					{
						if (FALSE == CheckHit(1))
						{
							if (FALSE == CheckHit(0))
							{
								Shot[Shots] = TRUE;
								SetShotPosition(Input.X - SHOTSIZE / 2, Input.Y - SHOTSIZE / 2,
									Shots);

								sound = rand() % MAXSOUNDS;

                                switch (sound)
                                {
                                    case 0:
                                        PlaySound(Miss1Sound, Miss1SoundSize, 0);

                                        break;

                                    case 1:
                                        PlaySound(Miss2Sound, Miss2SoundSize, 0);

                                        break;

                                    case 2:          
                                        PlaySound(Miss3Sound, Miss3SoundSize, 0);

                                        break;
                                }
							}
						}
					}

					Shots++;
				}

				else
				{
                    PlaySound(EmptySound, EmptySoundSize, 0);
				}
			}
		}

		AnimateClay(0);
		AnimateClay(1);

		Flip();

		if (FALSE == Clays[0].Flying && FALSE == Clays[1].Flying && Clays[1].Delay <= 0)
		{
			if (FALSE == Clays[0].Remove)
			{
				RemoveObject(Clays[0].ObjectID);
			}

			if (FALSE == Clays[1].Remove)
			{
				RemoveObject(Clays[1].ObjectID);
			}

			Flip();

			NumRounds++;

			if (NumRounds >= MAXROUNDS)
			{
				PrintScores();

				for (loop = 0; loop < MAXPLAYERS; loop++)
				{
					ClaysHit[loop] = 0;
				}

				Player	 = 0;

				scene++;

                if (scene >= MAXSCENES)
				{
                    scene = 0;
				}

				NumRounds = 0;

				LoadScene(scene, TRUE);
			}

			else
			{
				LoadScene(scene, FALSE);
			}
		}
	}

	return ERR_NOERROR;
}

DWORD LoadScene(WORD scene, BOOL Load)
{
    char    String[128];
	char	filename[80];
	BYTE	*sceneptr;
	short	number1;
	short	number2;
	u_long	*address;
	u_long	*address2;
	u_long	*address3;
    short   pan;

	Flight[0]	= 0.0f;
	Flight[1]	= 0.0f;
	Flight2[0]	= 0.0f;
	Flight2[1]	= 0.0f;
    Shot[0]		= FALSE;
    Shot[1]		= FALSE;
	Shots		= 0;

	if (TRUE == Load)
	{
/*
        sprintf(filename, "%s%sscene%i.scn", DIRECTORY, SubDir, scene);

		if (ERR_FILEERROR == FileRead(filename, SCENEADDRESS))
		{
			return ERR_FILEERROR;
		}
*/
	}

//    sceneptr    = (BYTE *)SCENEADDRESS;

    switch (scene)
    {
        case 0:
            sceneptr    = (BYTE *)Scenes1;
    
            break;

        case 1:
            sceneptr    = (BYTE *)Scenes2;
    
            break;

        case 2:
            sceneptr    = (BYTE *)Scenes3;
    
            break;
    }

    if (*(WORD *)sceneptr != VERSION)
	{
#ifdef DEBUG
        slPrint("Bad scene version in LoadScene.\n", slLocate(9,2));
#endif

		return ERR_FILEERROR;
	}

	sceneptr 	+= 2;

	NumClays	= *(WORD *)sceneptr;
    sceneptr    += 2;

	strcpy(Image, (char *)sceneptr);
	sceneptr	+= FILENAMELEN;

	Floor		= *(short *)sceneptr;
    sceneptr    += 2;

    ZLimit      = *(short *)sceneptr;
    sceneptr    += 2;

	ZOffscreen	= *(short *)sceneptr;
    ZOffscreen  = 2000;
    sceneptr    += 2;

	OnReport	= *(short *)sceneptr;
    sceneptr    += 2;

	Scene 		= (SceneStruct *)sceneptr;

    if (TRUE == Load)
    {
/*
    	sprintf(filename, "%s%s%s", DIRECTORY, SubDir, Image);

		if (ERR_FILEERROR == FileRead(filename, TIMADDRESS))
		{
        	return ERR_INITERROR;
    	}
*/
        
    	// Loads TIM and sets up sprites
        LoadPicture(scene);

		Flip();
    }

    if (NumClays > 2)
    {
    	number1	= rand() % NumClays;
    }

    else
    {
    	number1 = 0;
    }

    Clays[0].Position.x     = Scene[number1].Init.x;
    Clays[0].Position.y     = Scene[number1].Init.y;
    Clays[0].Position.z     = Scene[number1].Init.z;
    Clays[0].Init.x         = Scene[number1].Init.x;
    Clays[0].Init.y         = Scene[number1].Init.y;
    Clays[0].Init.z         = Scene[number1].Init.z;
    Clays[0].Rotation.x     = Scene[number1].Rot.x + 90;
    Clays[0].Rotation.y     = Scene[number1].Rot.y;
    Clays[0].Rotation.z     = Scene[number1].Rot.z;
    Clays[0].Scale.x        = Scene[number1].Scale.x;
    Clays[0].Scale.y        = Scene[number1].Scale.y;
    Clays[0].Scale.z        = Scene[number1].Scale.z;
    Clays[0].Speed          = Scene[number1].Speed;
    Clays[0].Delay          = Scene[number1].Delay;
    Clays[0].AngleY         = Scene[number1].AngleY;
    Clays[0].AngleZ         = Scene[number1].AngleZ;
    Clays[0].Rabbit         = Scene[number1].Rabbit;
    Clays[0].Remove         = Scene[number1].Remove;
    Clays[0].Water          = Scene[number1].Water;
    Clays[0].Velx           = Scene[number1].Speed * slSin(DEGtoANG(Scene[number1].AngleY));
    Clays[0].Vely           = Scene[number1].Speed * slSin(DEGtoANG(Scene[number1].AngleZ));
    Clays[0].Velz           = Scene[number1].Speed * slCos(DEGtoANG(Scene[number1].AngleZ));
    Clays[0].Hit            = FALSE;

    switch (Scene[number1].Color)
    {
    	case CC_WHITE:
            ClayModel[0][0].pntbl      = ClayPoints;
            ClayModel[0][0].nbPoint    = (Uint32)(ClayNumPoints / sizeof(POINT));
            ClayModel[0][0].pltbl      = ClayPolygons;
            ClayModel[0][0].nbPolygon  = (Uint32)(ClayNumPolygons / sizeof(POLYGON));
            ClayModel[0][0].attbl      = WhiteAttributes;
            ClayModel[0][0].vntbl      = NULL;
                     
            ClayModel[1][0].pntbl      = HitPoints;
            ClayModel[1][0].nbPoint    = (Uint32)(HitNumPoints / sizeof(POINT));
            ClayModel[1][0].pltbl      = HitPolygons;
            ClayModel[1][0].nbPolygon  = (Uint32)(HitNumPolygons / sizeof(POLYGON));
            ClayModel[1][0].attbl      = WhiteAttributes;
            ClayModel[1][0].vntbl      = NULL;
                
            ClayModel[2][0].pntbl      = ChipPoints;
            ClayModel[2][0].nbPoint    = (Uint32)(ChipNumPoints / sizeof(POINT));
            ClayModel[2][0].pltbl      = ChipPolygons;
            ClayModel[2][0].nbPolygon  = (Uint32)(ChipNumPolygons / sizeof(POLYGON));
            ClayModel[2][0].attbl      = WhiteAttributes;
            ClayModel[2][0].vntbl      = NULL;
                
    		break;

    	case CC_GREY:
            ClayModel[0][0].pntbl      = ClayPoints;
            ClayModel[0][0].nbPoint    = (Uint32)(ClayNumPoints / sizeof(POINT));
            ClayModel[0][0].pltbl      = ClayPolygons;
            ClayModel[0][0].nbPolygon  = (Uint32)(ClayNumPolygons / sizeof(POLYGON));
            ClayModel[0][0].attbl      = GreyAttributes;
            ClayModel[0][0].vntbl      = NULL;
                     
            ClayModel[1][0].pntbl      = HitPoints;
            ClayModel[1][0].nbPoint    = (Uint32)(HitNumPoints / sizeof(POINT));
            ClayModel[1][0].pltbl      = HitPolygons;
            ClayModel[1][0].nbPolygon  = (Uint32)(HitNumPolygons / sizeof(POLYGON));
            ClayModel[1][0].attbl      = GreyAttributes;
            ClayModel[1][0].vntbl      = NULL;
                
            ClayModel[2][0].pntbl      = ChipPoints;
            ClayModel[2][0].nbPoint    = (Uint32)(ChipNumPoints / sizeof(POINT));
            ClayModel[2][0].pltbl      = ChipPolygons;
            ClayModel[2][0].nbPolygon  = (Uint32)(ChipNumPolygons / sizeof(POLYGON));
            ClayModel[2][0].attbl      = GreyAttributes;
            ClayModel[2][0].vntbl      = NULL;
                
    		break;

    	case CC_ORANGE:
            ClayModel[0][0].pntbl      = ClayPoints;
            ClayModel[0][0].nbPoint    = (Uint32)(ClayNumPoints / sizeof(POINT));
            ClayModel[0][0].pltbl      = ClayPolygons;
            ClayModel[0][0].nbPolygon  = (Uint32)(ClayNumPolygons / sizeof(POLYGON));
            ClayModel[0][0].attbl      = OrangeAttributes;
            ClayModel[0][0].vntbl      = NULL;
                     
            ClayModel[1][0].pntbl      = HitPoints;
            ClayModel[1][0].nbPoint    = (Uint32)(HitNumPoints / sizeof(POINT));
            ClayModel[1][0].pltbl      = HitPolygons;
            ClayModel[1][0].nbPolygon  = (Uint32)(HitNumPolygons / sizeof(POLYGON));
            ClayModel[1][0].attbl      = OrangeAttributes;
            ClayModel[1][0].vntbl      = NULL;

            ClayModel[2][0].pntbl      = ChipPoints;
            ClayModel[2][0].nbPoint    = (Uint32)(ChipNumPoints / sizeof(POINT));
            ClayModel[2][0].pltbl      = ChipPolygons;
            ClayModel[2][0].nbPolygon  = (Uint32)(ChipNumPolygons / sizeof(POLYGON));
            ClayModel[2][0].attbl      = OrangeAttributes;
            ClayModel[2][0].vntbl      = NULL;
                
    		break;
	}

    AddObject(&ClayModel[0][0], &Clays[0].ObjectID, &Clays[0].Position, &Clays[0].Rotation, &Clays[0].Scale);
    AddAnimation(&ClayModel[1][0], Clays[0].ObjectID, 1);
    AddAnimation(&ClayModel[2][0], Clays[0].ObjectID, 2);

   	Clays[0].Flying = TRUE;
   	Clays[0].Delay 	= 0;

    if (NumClays > 2)
    {
		number2 = number1;

    	while (number2 == number1)
    	{
    		number2	= rand() % NumClays;
    	}
    }

    else
    {
    	number2 = 1;
    }

    Clays[1].Position.x     = Scene[number2].Init.x;
    Clays[1].Position.y     = Scene[number2].Init.y;
    Clays[1].Position.z     = Scene[number2].Init.z;
    Clays[1].Init.x         = Scene[number2].Init.x;
    Clays[1].Init.y         = Scene[number2].Init.y;
    Clays[1].Init.z         = Scene[number2].Init.z;
    Clays[1].Rotation.x     = Scene[number2].Rot.x + 90;
    Clays[1].Rotation.y     = Scene[number2].Rot.y;
    Clays[1].Rotation.z     = Scene[number2].Rot.z;
    Clays[1].Scale.x        = Scene[number2].Scale.x;
    Clays[1].Scale.y        = Scene[number2].Scale.y;
    Clays[1].Scale.z        = Scene[number2].Scale.z;
    Clays[1].Speed          = Scene[number2].Speed;
    Clays[1].Delay          = Scene[number2].Delay;
    Clays[1].AngleY         = Scene[number2].AngleY;
    Clays[1].AngleZ         = Scene[number2].AngleZ;
    Clays[1].Rabbit         = Scene[number2].Rabbit;
    Clays[1].Remove         = Scene[number2].Remove;
    Clays[1].Water          = Scene[number2].Water;
    Clays[1].Velx           = Scene[number2].Speed * slSin(DEGtoANG(Scene[number2].AngleY));
    Clays[1].Vely           = Scene[number2].Speed * slSin(DEGtoANG(Scene[number2].AngleZ));
    Clays[1].Velz           = Scene[number2].Speed * slCos(DEGtoANG(Scene[number2].AngleZ));
    Clays[1].Hit            = FALSE;

    switch (Scene[number2].Color)
    {
    	case CC_WHITE:
            ClayModel[0][1].pntbl      = ClayPoints;
            ClayModel[0][1].nbPoint    = (Uint32)(ClayNumPoints / sizeof(POINT));
            ClayModel[0][1].pltbl      = ClayPolygons;
            ClayModel[0][1].nbPolygon  = (Uint32)(ClayNumPolygons / sizeof(POLYGON));
            ClayModel[0][1].attbl      = WhiteAttributes;
            ClayModel[0][1].vntbl      = NULL;
                     
            ClayModel[1][1].pntbl      = HitPoints;
            ClayModel[1][1].nbPoint    = (Uint32)(HitNumPoints / sizeof(POINT));
            ClayModel[1][1].pltbl      = HitPolygons;
            ClayModel[1][1].nbPolygon  = (Uint32)(HitNumPolygons / sizeof(POLYGON));
            ClayModel[1][1].attbl      = WhiteAttributes;
            ClayModel[1][1].vntbl      = NULL;
                         
            ClayModel[2][1].pntbl      = ChipPoints;
            ClayModel[2][1].nbPoint    = (Uint32)(ChipNumPoints / sizeof(POINT));
            ClayModel[2][1].pltbl      = ChipPolygons;
            ClayModel[2][1].nbPolygon  = (Uint32)(ChipNumPolygons / sizeof(POLYGON));
            ClayModel[2][1].attbl      = WhiteAttributes;
            ClayModel[2][1].vntbl      = NULL;
                         
    		break;

    	case CC_GREY:
            ClayModel[0][1].pntbl      = ClayPoints;
            ClayModel[0][1].nbPoint    = (Uint32)(ClayNumPoints / sizeof(POINT));
            ClayModel[0][1].pltbl      = ClayPolygons;
            ClayModel[0][1].nbPolygon  = (Uint32)(ClayNumPolygons / sizeof(POLYGON));
            ClayModel[0][1].attbl      = GreyAttributes;
            ClayModel[0][1].vntbl      = NULL;
                     
            ClayModel[1][1].pntbl      = HitPoints;
            ClayModel[1][1].nbPoint    = (Uint32)(HitNumPoints / sizeof(POINT));
            ClayModel[1][1].pltbl      = HitPolygons;
            ClayModel[1][1].nbPolygon  = (Uint32)(HitNumPolygons / sizeof(POLYGON));
            ClayModel[1][1].attbl      = GreyAttributes;
            ClayModel[1][1].vntbl      = NULL;
                
            ClayModel[2][1].pntbl      = ChipPoints;
            ClayModel[2][1].nbPoint    = (Uint32)(ChipNumPoints / sizeof(POINT));
            ClayModel[2][1].pltbl      = ChipPolygons;
            ClayModel[2][1].nbPolygon  = (Uint32)(ChipNumPolygons / sizeof(POLYGON));
            ClayModel[2][1].attbl      = GreyAttributes;
            ClayModel[2][1].vntbl      = NULL;
                         
    		break;

    	case CC_ORANGE:
            ClayModel[0][1].pntbl      = ClayPoints;
            ClayModel[0][1].nbPoint    = (Uint32)(ClayNumPoints / sizeof(POINT));
            ClayModel[0][1].pltbl      = ClayPolygons;
            ClayModel[0][1].nbPolygon  = (Uint32)(ClayNumPolygons / sizeof(POLYGON));
            ClayModel[0][1].attbl      = OrangeAttributes;
            ClayModel[0][1].vntbl      = NULL;
                     
            ClayModel[1][1].pntbl      = HitPoints;
            ClayModel[1][1].nbPoint    = (Uint32)(HitNumPoints / sizeof(POINT));
            ClayModel[1][1].pltbl      = HitPolygons;
            ClayModel[1][1].nbPolygon  = (Uint32)(HitNumPolygons / sizeof(POLYGON));
            ClayModel[1][1].attbl      = OrangeAttributes;
            ClayModel[1][1].vntbl      = NULL;
                
            ClayModel[2][1].pntbl      = ChipPoints;
            ClayModel[2][1].nbPoint    = (Uint32)(ChipNumPoints / sizeof(POINT));
            ClayModel[2][1].pltbl      = ChipPolygons;
            ClayModel[2][1].nbPolygon  = (Uint32)(ChipNumPolygons / sizeof(POLYGON));
            ClayModel[2][1].attbl      = OrangeAttributes;
            ClayModel[2][1].vntbl      = NULL;
                         
    		break;
	}

    AddObject(&ClayModel[0][1], &Clays[1].ObjectID, &Clays[1].Position, &Clays[1].Rotation, &Clays[1].Scale);
    AddAnimation(&ClayModel[1][1], Clays[1].ObjectID, 1);
    AddAnimation(&ClayModel[2][1], Clays[1].ObjectID, 2);

    if (Clays[1].Delay <= 0)
    {
    	Clays[1].Flying = TRUE;
    }

    WaitForStart(TRUE);

    pan = Clays[0].Position.x * 127 / 160;

    PlaySound(LaunchSound, LaunchSoundSize, pan);
}

DWORD AnimateClay(short clay)
{
    short   x;
    short   y;
    short   z;
    short   pan;

	if (TRUE == Clays[clay].Flying)
	{
		if (TRUE == Clays[clay].Rabbit)
		{
            Flight[clay]            += .40;
            Flight2[clay]           += .40;

            Clays[clay].Position.x  = Clays[clay].Init.x + (Clays[clay].Velx *
                Flight[clay] / 65536) / 50.0f;

            Clays[clay].Position.z  = Clays[clay].Init.z;

			if (FALSE == Clays[clay].Hit)
			{
                Clays[clay].Position.y  = Clays[clay].Init.y -
                    (Clays[clay].Vely * Flight2[clay] / 65536
                    * RABBITMULTIPLY - 1.5 * 32.2 * Flight2[clay] *
                    Flight2[clay]) / 50.0f;
			}

            if (Clays[clay].Position.y >= Clays[clay].Init.y)
			{
				Flight2[clay] = 0.0f;

				if (FALSE == Clays[clay].Hit)
				{
					Clays[clay].Speed 	*= .70f;
					Clays[clay].Vely	= Clays[clay].Speed *
                        slSin(DEGtoANG(Clays[clay].AngleZ));
				}
			}
		}

		else
		{
            Flight[clay] += .40;

            Clays[clay].Position.x  = Clays[clay].Init.x + ((Clays[clay].Velx * Flight[clay] / 65536) / 50.0f);
            Clays[clay].Position.y  = Clays[clay].Init.y -
                (Clays[clay].Vely * Flight[clay] / 65536 -
                1.00 * 32.2 * Flight[clay] * Flight[clay]) / 50.0f;
            Clays[clay].Position.z  = Clays[clay].Init.z + ((Clays[clay].Velz * Flight[clay] / 65536) / 50.0f);
		}

		MoveObject(Clays[clay].ObjectID, &Clays[clay].Position);

		if (TRUE == Clays[clay].Rabbit && TRUE == Clays[clay].Flying)
		{
			if (Clays[clay].Init.x < 0)
			{
                if (Clays[clay].Position.x >= 0 && TRUE == CheckScreen(Clays[clay].ObjectID))
				{
					Clays[clay].Flying = FALSE;

        			if (TRUE == Clays[clay].Remove)
					{
						RemoveObject(Clays[clay].ObjectID);
					}
				}
			}

			else
			{
                if (Clays[clay].Position.x <= 0 && TRUE == CheckScreen(Clays[clay].ObjectID))
				{
					Clays[clay].Flying = FALSE;

        			if (TRUE == Clays[clay].Remove)
					{
						RemoveObject(Clays[clay].ObjectID);
					}
				}
			}
		}

        else if (Clays[clay].Position.z > ZOffscreen && TRUE == CheckScreen(Clays[clay].ObjectID))
		{
			Clays[clay].Flying = FALSE;

        	if (TRUE == Clays[clay].Remove)
			{
				RemoveObject(Clays[clay].ObjectID);
			}
		}

        else if (Clays[clay].Position.z > ZLimit && TRUE ==
			CheckFloor(Clays[clay].ObjectID, Floor))
		{
			Clays[clay].Flying = FALSE;

			if (TRUE == Clays[clay].Remove)
			{
				RemoveObject(Clays[clay].ObjectID);
			}

			if (TRUE == Clays[clay].Water && FALSE == Clays[clay].Hit)
			{
                PlaySound(SplashSound, SplashSoundSize, 0);
			}
		}
	}

	else if (Clays[clay].Delay > 0)
	{
		Clays[clay].Delay--;

		if (0 == Clays[clay].Delay)
		{
			Clays[clay].Flying = TRUE;

            pan         = Clays[clay].Position.x * 127 / 160;

            PlaySound(LaunchSound, LaunchSoundSize, pan);
		}
	}

	return ERR_NOERROR;
}

DWORD ReadModel(DWORD Model, PDATA *address)
{
	char filename[FILENAMELEN];

    strcpy(filename, DIRECTORY);
    strcat(filename, Model);
    strcat(filename, ".s3d");

    if (NULL == address)
    {
#ifdef DEBUG
        slPrint("Bad Parameters to ReadModel\n", slLocate(9,2));
#endif

    	return ERR_BADPARAMS;
    }

	if (ERR_FILEERROR == FileRead(filename, address))
	{
        return ERR_FILEERROR;
    }

	return ERR_NOERROR;
}

DWORD AddTIM(char *name)
{
	char filename[FILENAMELEN];

/*
	strcpy(filename, DIRECTORY);
	strcat(filename, name);
	strcat(filename, ".tim");

	if (ERR_FILEERROR == FileRead(filename, TIMADDRESS))
	{
		return ERR_FILEERROR;
	}

	LoadTIM(TIMADDRESS);
*/

	return ERR_NOERROR;
}

BOOL CheckHit(short clay)
{
	BOOL 	RetVal = FALSE;
	short	distance;
	short	xdir;
	short	ydir;
    short	sound;

	if (TRUE == Clays[clay].Flying && FALSE == Clays[clay].Hit && TRUE ==
		CheckIntersection(Clays[clay].ObjectID, Input.X, Input.Y, RANGE, &distance, &xdir, &ydir))
	{
		RetVal			= TRUE;
		Clays[clay].Hit	= TRUE;

		ClaysHit[Player]++;

		if (TRUE == Clays[clay].Rabbit)
		{
			Clays[clay].Flying 	= FALSE;

            Clays[clay].Rotation.x  = 10 + 90;
			RotateObject(Clays[clay].ObjectID, &Clays[clay].Rotation);

            Clays[clay].Position.y = Clays[clay].Init.y;
			MoveObject(Clays[clay].ObjectID, &Clays[clay].Position);

			SetObjectFrame(Clays[clay].ObjectID, 1);

			if (TRUE == Clays[clay].Remove)
			{
				RemoveObject(Clays[clay].ObjectID);
			}
		}

		else if (distance < INNERRANGE)
		{
			SetObjectFrame(Clays[clay].ObjectID, 1);
		}

		else
		{
			if (xdir < 0)
			{
				if (ydir < 0)
				{
                    Clays[clay].Rotation.z = 180;
				}

				else
				{
                    Clays[clay].Rotation.z  = 270;
				}
			}

			else
			{
				if (ydir < 0)
				{
                    Clays[clay].Rotation.z  = 90;
				}
			}

			SetObjectFrame(Clays[clay].ObjectID, 2);
			RotateObject(Clays[clay].ObjectID, &Clays[clay].Rotation);
		}

		sound = rand() % MAXSOUNDS;

        switch (sound)
        {
            case 0:
                PlaySound(Hit1Sound, Hit1SoundSize, 0);

                break;

            case 1:
                PlaySound(Hit2Sound, Hit2SoundSize, 0);

                break;

            case 2:          
                PlaySound(Hit3Sound, Hit3SoundSize, 0);

                break;

        }
	}

	return RetVal;
}

DWORD PrintScores()
{
	char 	string[20];
	WORD    Player = 0;

    DrawTextString("SCORE BOARD;", 4, 1);
	DrawTextString("\\\\\\\\\\\\\\\\\\\\\\\\", 4, 2);

	ClaysTotal[Player] += ClaysHit[Player];

	sprintf(string, "PLAYER %d;  %2d %3d", Player + 1, ClaysHit[Player], ClaysTotal[Player]);

	DrawTextString(string, 1, 4);
	DrawTextString("SHOOT TO CONTINUE.", 1, 12);

	while (1)
	{
        ReadInput(&Input, 0);

		if (Input.Type != CON_NONE)
		{
			if ((BUT_TRIGGER & Input.Buttons) != 0)
            {
                PlaySound(GunSound, GunSoundSize, 0);

				break;
			}
		}

    	Flip();
	}

	ClearText();

    Input.X     = 0;
    Input.Y     = 0;

	SetInputMousePosition(Input.X, Input.Y);
	SetMousePosition(Input.X - MOUSESIZE / 2, Input.Y - MOUSESIZE / 2);

	return ERR_NOERROR;
}

DWORD WaitForStart(BOOL PlayPull)
{
	DrawTextString("PRESS START.", 4, 12);

	while (1)
	{
    	Flip();

        ReadInput(&Input, 0);

		if (Input.Type != CON_NONE)
		{
            if ((BUT_START & Input.Buttons) != 0)
			{
                if (TRUE == PlayPull)
                {
                    PlaySound(PullSound, PullSoundSize, 0);
                }

				break;
			}
		}
	}

	ClearText();

    Input.X     = 0;
    Input.Y     = 0;

	SetInputMousePosition(Input.X, Input.Y);
	SetMousePosition(Input.X - MOUSESIZE / 2, Input.Y - MOUSESIZE / 2);

	return ERR_NOERROR;
}
