// **************************************************************************
// *				 Sporting Clays for the Playstation						*
// *					   (C) 1999 Charles Doty                           	*
// *	 	  Display Header file contains screen related code				*
// **************************************************************************

#ifndef __DISPLAY_H
#define __DISPLAY_H

#include "defines.h"

#define MAXSPRITES      2
#define NBG1_CEL_ADR    (VDP2_VRAM_B0 + 0x00000)
#define NBG1_COL_ADR    (VDP2_COLRAM  + 0x00400)
#define NBG2_CEL_ADR    (VDP2_VRAM_B1 + 0x02000)
#define NBG2_MAP_ADR    (VDP2_VRAM_B1 + 0x12000)
#define NBG2_COL_ADR    (VDP2_COLRAM  + 0x00200)
#define BACK_COL_ADR    (VDP2_VRAM_A1 + 0x1fffe)

DWORD DisplayInitialize();
  // Initializes the display

DWORD Flip();
  // Flips the display buffers

DWORD LoadPicture(long scene);
  // Loads a TIM a creates 2 display sprites from it

DWORD LoadMouse(WORD Picture);
  // Loads a Saturn texture and creates a mouse sprites from it

DWORD LoadShot(WORD Picture, WORD shot);
  // Loads a Saturn texture and creates a shot sprites from it

DWORD SetMousePosition(short x, short y);
  // Sets the position of the mouse

DWORD SetShotPosition(short x, short y, short shot);
  // Sets the position of the shot

BOOL IsNTSC();
  // Returns TRUE if the display is NTSC, and FALSE for PAL.

DWORD InitializeTextDisplay();
  // Initialize GsBG, GsMap, and GsCell structures.

DWORD ClearText();
  // Clears all text off the screen

DWORD DrawTextString(char *string, long x, long y);
  // Draws text to the screen. X and Y are tile positions.

void Cel2VRAM(Uint8 *Cel_Data, void *Cell_Adr, Uint32 Size);
  // Transfers CELS to VRAM

void Map2VRAM64(Uint16 *Map_Data, void *Map_Adr, Uint16 width, Uint16 height, Uint16 palnum, Uint32 mapoff);
  // Transfers MAP to VRAM

void Map2VRAM32(Uint16 *Map_Data, void *Map_Adr, Uint16 width, Uint16 height, Uint16 palnum, Uint32 mapoff);
  // Transfers MAP to VRAM

void Pal2CRAM(Uint16 *Pal_Data, void *Col_Adr, Uint32 Entries);
  // Transfers PAL to VRAM

#endif
