// **************************************************************************
// *				 Sporting Clays for the Playstation						*
// *					   (C) 1999 Charles Doty                           	*
// *	 	   Display Source file contains screen related code				*
// **************************************************************************

#include "display.h"
#include "scene3d.h"

FIXED       MousePos[XYZS];                     // Mouse position
FIXED       ShotPos[MAXSHOTS][XYZS];              // Shots sprite positions
BOOL		Is_NTSC;							// is the display in NTSC mode?
BOOL		MouseLoaded;						// Has the mouse image been loaded?
BOOL		ShotsLoaded[MAXSHOTS];				// Has the shot image been loaded?
WORD		IndexArray[(SCREENHEIGHT / TILESIZE) * (SCREENWIDTH / TILESIZE)];

extern BOOL     MouseUsed;
extern BOOL     PadUsed;
extern BOOL     Shot[2];                            // Draw shot (miss) 1/2
extern Uint8    Bitmap1[];
extern DWORD    Bitmap1Size;
extern Uint8    Bitmap2[];
extern DWORD    Bitmap2Size;
extern Uint8    Bitmap3[];
extern DWORD    Bitmap3Size;
extern Uint16   Pal1[];
extern Uint16   Pal2[];
extern Uint16   Pal3[];
extern Uint16   FontMap[];
extern Uint8    FontCell[];
extern Uint16   FontPal[];
extern Uint16   CursorPicture[];
extern Uint16   ShotPicture[];
 
TEXTURE Textures[] =
{
    TEXDEF(16, 16, 0),
    TEXDEF(16, 16, 256)
};

SPR_ATTR SpriteAttributes[] =
{
    SPR_ATTRIBUTE(0, No_Palet, No_Gouraud, CL32KRGB | ECdis, sprNoflip),
    SPR_ATTRIBUTE(1, No_Palet, No_Gouraud, CL32KRGB | ECdis, sprNoflip),
    SPR_ATTRIBUTE(1, No_Palet, No_Gouraud, CL32KRGB | ECdis, sprNoflip)
};

PICTURE  SpriteData[]   =
{
    PICDEF(0, COL_32K, CursorPicture),
    PICDEF(1, COL_32K, ShotPicture)
};

DWORD DisplayInitialize()
{
	long	loop;

    slInitSystem(TV_320x240, Textures, 2);

    slTVOff();

	slColRAMMode(CRM16_1024);
    slBack1ColSet((void *)BACK_COL_ADR, 0);

    slPriorityNbg0(3);
    slPriorityNbg2(2);
    slPriorityNbg1(1);

    slCharNbg2(COL_TYPE_256, CHAR_SIZE_2x2);
    slPageNbg2((void *)NBG2_CEL_ADR, 0, PNB_1WORD | CN_10BIT);
    slPlaneNbg2(PL_SIZE_1x1);
    slMapNbg2((void *)NBG2_MAP_ADR, (void *)NBG2_MAP_ADR,
        (void *)NBG2_MAP_ADR, (void *)NBG2_MAP_ADR);

    slScrPosNbg1(0, 0);
    slScrPosNbg2(0, 0);

    Cel2VRAM(FontCell, (void *)NBG2_CEL_ADR, 12288);
    Map2VRAM32(FontMap, (void *)NBG2_MAP_ADR, 32, 32, 1, 0);
    Pal2CRAM(FontPal, (void *)NBG2_COL_ADR, 256);

	Scene3DInitialize();

	MouseLoaded = FALSE;

    for (loop = 0; loop < MAXSHOTS; loop++)
	{
        ShotsLoaded[loop]   = FALSE;

        ShotPos[loop][X]      = toFIXED(0);
        ShotPos[loop][Y]      = toFIXED(0);
        ShotPos[loop][Z]      = toFIXED(170);
        ShotPos[loop][S]      = toFIXED(1.0);
	}

    MousePos[X] = toFIXED(0);
    MousePos[Y] = toFIXED(0);
    MousePos[Z] = toFIXED(170);
    MousePos[S] = toFIXED(1.0);

	InitializeTextDisplay();

	return ERR_NOERROR;
}

DWORD Flip()
{
    long	loop;

	for (loop = 0; loop < MAXSHOTS; loop++)
	{
        if (TRUE == Shot[loop])
    	{
            slDispSprite(ShotPos[loop],
                (SPR_ATTR *)&(SpriteAttributes[loop + 1].texno), 0);
    	}
	}

    if (TRUE == MouseUsed || TRUE == PadUsed)
    {
        slDispSprite(MousePos, (SPR_ATTR *)&(SpriteAttributes[0].texno), 0);
    }

    Render();

    slSynch();

	return ERR_NOERROR;
}

DWORD LoadPicture(long scene)
{
    slTVOff();

    slInitBitMap(bmNBG1, BM_512x256, (void *)NBG1_CEL_ADR);

    switch (scene)
    {
        case 0:
            Pal2CRAM(Pal1, (void *)NBG1_COL_ADR, 256);
            slBMPut(-(SCREENWIDTH / 2), -(SCREENHEIGHT / 2),
                SCREENWIDTH / 2 - 1, SCREENWIDTH / 2 - 1, Bitmap1);

            break;

        case 1:
            Pal2CRAM(Pal2, (void *)NBG1_COL_ADR, 256);
            slBMPut(-(SCREENWIDTH / 2), -(SCREENHEIGHT / 2),
                SCREENWIDTH / 2 - 1, SCREENWIDTH / 2 - 1, Bitmap2);

            break;

        case 2:
            Pal2CRAM(Pal3, (void *)NBG1_COL_ADR, 256);
            slBMPut(-(SCREENWIDTH / 2), -(SCREENHEIGHT / 2),
                SCREENWIDTH / 2 - 1, SCREENWIDTH / 2 - 1, Bitmap3);

            break;
    }
    
    slBMPaletteNbg1(2);
    slScrAutoDisp(NBG0ON | NBG1ON  | NBG2ON);
    slTVOn();
    
	return ERR_NOERROR;
}

DWORD LoadMouse(WORD Picture)
{
    TEXTURE *Texture    = (TEXTURE *)Textures + SpriteData[Picture].texno;
 
    if (Picture >= MAXSPRITES)
	{
#ifdef DEBUG
		printf("Bad Parameters to LoadMouse.\n");
#endif

		return ERR_BADPARAMS;
	}

    slDMACopy((void *)SpriteData[Picture].pcsrc,
        (void *)(SpriteVRAM + ((Texture->CGadr) << 3)),
        (Uint32)((Texture->Hsize * Texture->Vsize * 4) >>
        (SpriteData[Picture].cmode)));

    // Sets up Mouse Sprite
    MousePos[X]         = toFIXED(0);
    MousePos[Y]         = toFIXED(0);
    MouseLoaded         = TRUE;

	return ERR_NOERROR;
}

DWORD LoadShot(WORD Picture, WORD shot)
{
    TEXTURE *Texture    = (TEXTURE *)Textures + SpriteData[Picture + 1].texno;
 
    if (Picture >= MAXSPRITES)
	{
#ifdef DEBUG
        printf("Bad Parameters to LoadShot.\n");
#endif

		return ERR_BADPARAMS;
	}

    slDMACopy((void *)SpriteData[Picture + 1].pcsrc,
        (void *)(SpriteVRAM + ((Texture->CGadr) << 3)),
        (Uint32)((Texture->Hsize * Texture->Vsize * 4) >>
        (SpriteData[Picture + 1].cmode)));

    // Sets up Shot
    ShotPos[shot][X]    = toFIXED(0);
    ShotPos[shot][Y]    = toFIXED(0);
    ShotsLoaded[shot]   = TRUE;

	return ERR_NOERROR;
}

DWORD SetMousePosition(short x, short y)
{
	if (FALSE == MouseLoaded)
	{
#ifdef DEBUG
		printf("Mouse Image has not been loaded prior to calling SetMousePosition.\n");
#endif

		return ERR_INITERROR;
	}

    MousePos[X] = toFIXED(x);
    MousePos[Y] = toFIXED(y);

	return ERR_NOERROR;
}

DWORD SetShotPosition(short x, short y, short shot)
{
	if (FALSE == ShotsLoaded[shot])
	{
#ifdef DEBUG
		printf("Shot Image has not been loaded prior to calling SetShotPosition.\n");
#endif

		return ERR_INITERROR;
	}

    ShotPos[shot][X]  = toFIXED(x);
    ShotPos[shot][Y]  = toFIXED(y);

    return ERR_NOERROR;
}

BOOL IsNTSC()
{
	return Is_NTSC;
}

DWORD InitializeTextDisplay()
{
/*
    char    filename[FILENAMELEN];

	strcpy(filename, DIRECTORY);
	strcat(filename, CHAR_FILE);

	if (ERR_FILEERROR == FileRead(filename, address))
	{
		return ERR_FILEERROR;
	}
*/

    ClearText();

	return ERR_NOERROR;
}

DWORD ClearText()
{
    WORD    *start;
	short 	outerloop;
	short 	innerloop;

    start   = (WORD *)NBG2_MAP_ADR;

    for (outerloop = 0; outerloop < 32; outerloop++)
	{
        for (innerloop = 0; innerloop < 32; innerloop++)
		{
            *start   = 0x1060;

            start++;
		}
	}

	return ERR_NOERROR;
}

DWORD DrawTextString(char *string, long x, long y)
{
	WORD 	*start;
	WORD	length;
	WORD 	loop;
	char	value;

	if (NULL == string || y < 0 || y >= SCREENHEIGHT / TILESIZE || x < 0 ||
		x >= SCREENWIDTH / TILESIZE)
	{
		return ERR_BADPARAMS;
	}

    start   = (WORD *)(NBG2_MAP_ADR + ((y * 32 + x) << 1));
	length 	= strlen(string);

	if (length + x > SCREENWIDTH / TILESIZE)
	{
		length = SCREENWIDTH / TILESIZE - x;
	}

	for (loop = 0; loop < length; loop++)
	{
		value = string[loop];

		if (value < 48)
		{
            *start = 0x1060;
		}

		else
		{
            *start = 0x1000 | ((value - 16) << 1);
		}

		start++;
	}

	return ERR_NOERROR;
}

void Cel2VRAM(Uint8 *Cel_Data, void *Cell_Adr, Uint32 Size)
{
    Uint32  loop;
    Uint8   *VRAM;

	VRAM = (Uint8 *)Cell_Adr;

    for (loop = 0; loop < Size; loop++)
    {
		*(VRAM++) = *(Cel_Data++);
    }
}

void Map2VRAM64(Uint16 *Map_Data, void *Map_Adr, Uint16 width, Uint16 height, Uint16 palnum, Uint32 mapoff)
{
    Uint16  innerloop;
    Uint16  outerloop;
    Uint16  paloff;
    Uint16  *VRAM;

    paloff  = palnum << 12;
    VRAM    = (Uint16 *)Map_Adr;
	
    for (outerloop = 0; outerloop < height; outerloop++)
    {
        for (innerloop = 0; innerloop < width; innerloop++)
        {
			*VRAM++ = (*Map_Data | paloff) + mapoff;
			Map_Data++;
		}

        VRAM += (64 - width);
	}
}

void Map2VRAM32(Uint16 *Map_Data, void *Map_Adr, Uint16 width, Uint16 height, Uint16 palnum, Uint32 mapoff)
{
    Uint16  innerloop;
    Uint16  outerloop;
    Uint16  paloff;
    Uint16  *VRAM;

    paloff  = palnum << 12;
    VRAM    = (Uint16 *)Map_Adr;
	
    for (outerloop = 0; outerloop < height; outerloop++)
    {
        for (innerloop = 0; innerloop < width; innerloop++)
        {
            *VRAM++ = *Map_Data + mapoff;
			Map_Data++;
		}

        VRAM += (32 - width);
	}
}

void Pal2CRAM(Uint16 *Pal_Data, void *Col_Adr, Uint32 Entries)
{
    Uint16 loop;
	Uint16 *VRAM;

	VRAM = (Uint16 *)Col_Adr;

    for (loop = 0; loop < Entries; loop++)
    {
        *(VRAM++) = *(Pal_Data++);
    }
}
