// **************************************************************************
// *				 Sporting Clays for the Playstation						*
// *					   (C) 1999 Charles Doty                           	*
// *	 	  Display Header file contains screen related code				*
// **************************************************************************

#ifndef __DEFINES_H
#define	__DEFINES_H

//#define DEBUG
// Adds debug messages

//#define COMPUTER
// Reads files through caetla

#ifndef WIN32
#include <sgl.h>
#include <sys/types.h>
#endif

typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;

#define BOOL				long
#define TRUE				1
#define FALSE 				0

// Screen defines
#define SCREENWIDTH     	320
#define SCREENHEIGHT    	240
#define TILESIZE    		16

// Error defines
#define	ERR_NOERROR			0x00000000		// No error
#define ERR_BADPARAMS		0x00000001      // Parameters to a function are incorrect
#define ERR_NONEAVAILABLE   0x00000002		// No objects available
#define ERR_FILEERROR		0x00000003		// Unable to open file
#define ERR_INITERROR		0x00000004		// Error while initializing
#define ERR_PLAYERROR		0x00000005		// Unable to play sound

// Object defines
#define MAXOBJECTS			2               // Maximum 3D Objects
#define MAXFRAMES			3				// Maximum frames of animation per 3d object
#define MAXSHOTS			2				// Maximum number of shots allowed
#define SHOTSIZE			16				// Size of Shot Image
#define MAXPLAYERS			4				// Maximum players in a game

// Filename defines
#define FILENAMELEN			80

// Controller flags
#define	DIR_CENTER			0x00000000		// Center
#define	DIR_UP				0x00000001		// Up
#define	DIR_DOWN			0x00000002		// Down
#define	DIR_LEFT			0x00000004		// Left
#define	DIR_RIGHT			0x00000008		// Right

// Button flags
#define	BUT_NONE			0x00000000		// No buttons pressed
#define	BUT_START			0x00000001		// Start pressed
#define BUT_LEFT			0x00000002		// Mouse left button pressed
#define BUT_TRIGGER			0x00000002		// Trigger pressed
#define BUT_RIGHT			0x00000004		// Mouse right button pressed

// Controller Types
#define CON_NONE			0x00000000		// None
#define CON_GUN				0x00000001		// Gun controller
#define CON_MOUSE			0x00000002		// Mouse controller
#define CON_PAD				0x00000003		// Standard pad controller

// Input defines
#define NUMCONTROLLERS      2               // Number of controllers supported

#ifdef COMPUTER
//#define DIRECTORY           "pcdrv:data//"  // Location of files
#else
#define DIRECTORY           "\\DATA\\"  // Location of files
#endif

#ifndef WIN32
typedef struct
{
    short   x;
    short   y;
    short   w;
    short   h;
}RECT;
#endif

typedef struct
{
    short   x;                              // X position
    short   y;                              // Y position
    short   z;                              // Z position
}POS;

typedef struct 
{
    short   x;                              // X rotation
    short   y;                              // Y rotation
    short   z;                              // Z rotation
}ROT;

typedef struct
{
    short   x;                              // X scale
    short   y;                              // Y scale
    short   z;                              // Z scale
}SCALE;

#define PI 					3.14285714

#endif
