;
; PDA C Startup module
;
; note: Can't have usual BSS section because there's only 2K of SRAM
; and the area after the program is supposed to be ROM
; Stack will presumably be in the SRAM so local variables are OK.
;
; So, lets just initialise the stack pointer.
;
; Need to discuss start-up with someone that knows.
; Entry Point is useless but by putting this first we can
; just load it as a binary and jump to the start.
;
	opt	c+	;must be case sensitive

	section	.text
	section	.ctors
	section	.dtors
	section	.rdata
	section	.data
	section	.sdata
	section	.sbss
	section	.bss

	xdef	__SN_ENTRY_POINT
	xdef	__gccmain
	xdef	myputch
	xref	main
    xref    irq_handler
    xref    fiq_handler

SRAMbase	equ	$01000000	;start of SRAM (in second area)
SRAMsize	equ	$800

	section	.text
	code32

	dcb	"SN"
	dcb	0,0

__SN_ENTRY_POINT
	ldr	r1,=(SRAMbase+SRAMsize-64)
	mov	sp,r1

	stmfd	sp!,{r0,lr}	;save r0 & link register
	bl	main	;branch and link user code
armcode	ldmfd	sp!,{r0,lr}	;restore r0 & link register

	mov	pc,lr	;return

;
; ARM mode dummy __gccmain called from main to init BSS
;
__gccmain	mov	pc,lr	;dummy init bss routine

	ltorg

    xdef  sys_handler
sys_handler:
	swi	1
	mov	pc, lr

    xdef  sys_save
sys_save:
	swi	3
	mov	pc, lr

    xdef  sys_clock
sys_clock:
	swi	4
	mov	pc, lr

    xdef  sys_execset
sys_execset:
	swi	8
	mov	pc, lr

    xdef  sys_exec
sys_exec:
	swi	9

    xdef  sys_gettime
sys_gettime:
	swi	14
	mov	pc, lr

    xdef  sys_pscomm
sys_pscomm:
	swi	17
	mov	pc, lr

    xdef  sys_status
sys_status:
	swi	19
	ldr	r0, [r0]
	mov	pc, lr

    xdef  sys_appnum
sys_appnum:
	swi	22
	mov	pc, lr

    xdef  IntIRQ
IntIRQ:
	stmdb	sp!,{r0-r3,lr}
    bl  irq_handler
	ldmia	sp!,{r0-r3,pc}

    xdef  IntFIQ
IntFIQ:
	stmdb	sp!,{r0-r3,lr}
    bl      fiq_handler
	ldmia	sp!,{r0-r3,pc}

;
; Here is our putch() routine. The special undefined instruction causes
; a trap to the emulator app so it can print the characters
; note that since C program is all in ARM mode this routine must
; also be entered in ARM mode.
;

myputch	dcd	$E6000010
	mov	pc,lr

	end

