// **************************************************************************
// *                Sporting Clays for the Pocketstation                    *
// *					   (C) 1999 Charles Doty                           	*
// *	 		   Main Source file contains startup code					*
// **************************************************************************

#include "main.h"
#include "rand.h"

const BYTE ClayImage[2]	= {0x06, 0x0F};
										//0110000
                                        //1111000

const BYTE Explode[2]  	= {0x06, 0x03};
										//01100000
                                        //11000000

const BYTE Target[8]    = {0x06, 0x09, 0x09, 0x06};
                                        //01100000
                                        //10010000
                                        //10010000
                                        //01100000

const BYTE Gun[3][4]	= {{0x03, 0x06, 0x0C, 0x18}, {0x18, 0x18, 0x18, 0x18},
	{0xC0, 0x60, 0x30, 0x18}};
										//11000000 00011000 00000011
										//01100000 00011000 00000110
										//00110000 00011000 00001100
										//00011000 00011000 00011000

const BYTE Numbers[10][5]	=
{{0x0E, 0x0A, 0x0A, 0x0A, 0x0E}, {0x04, 0x06, 0x04, 0x04, 0x04}, {0x0E, 0x08, 0x0E, 0x02, 0x0E},
 {0x0E, 0x08, 0x0E, 0x08, 0x0E}, {0x0A, 0x0A, 0x0E, 0x08, 0x08}, {0x0E, 0x02, 0x0E, 0x08, 0x0E},
 {0x0E, 0x02, 0x0E, 0x0A, 0x0E}, {0x0E, 0x0A, 0x0A, 0x08, 0x08}, {0x0E, 0x0A, 0x0E, 0x0A, 0x0E},
 {0x0E, 0x0A, 0x0E, 0x08, 0x0E}};

typedef struct
{
	long	x;
	long	y;
	long	rise;
	short	direction;
	WORD	delay;
	WORD	hit;
} Clay;

typedef void (*func)();
short			FireLeft 	= FALSE;
short			FireRight 	= FALSE;
volatile int 	VsyncCount 	= 0;
func 			IntTable[14];
DWORD 			OffScreen[32];
int 			volume;
Clay			Clays[MAXCLAYS];
BYTE			ClaysHit 	= 0;
BYTE			TotalScore 	= 0;

void  LaunchClay(BYTE clay);
void  MoveClay(BYTE clay);
void  DrawTargets();
void  PrintScores();
void  timer0_handler();
void  timer2_handler();
DWORD VSync();
void  printf(char* ptr);

extern void IntIRQ();
extern void IntFIQ();

int main()
{
    WORD   *ptr;
    BYTE    Key;
    int     loop;
	int 	data;
    BYTE    Pos;

    ptr      	= (WORD *)0x0D000000;
    *ptr     	= 0x0078;       	// ROT=0, DISON=1, FR=16Hz, CPEN=1,
                                    // DISMOD=000
	sys_clock(5);

	data 		= sys_status();
	volume 		= (data >> 18) & 0x3;
	volume 		= volume * volume * 2;

	// mask interrupt
	*(volatile unsigned int *)0xa00000c	= 0x3fff;
	*(volatile unsigned int *)0xa000008 = 0x0a00;

	// register interrupt handlers
	sys_handler(1, IntIRQ);
	sys_handler(2, IntFIQ);

	IntTable[7] 	= timer0_handler;
	IntTable[13] 	= timer2_handler;

	// Setup Timer 0
	*(volatile unsigned int *)0xa800008 &= ~0x4;	// Stop timer */
	*(volatile unsigned int *)0xa800000 = 38000;

	// enable interrupt
	*(volatile unsigned int *)0xa000010 = 0x2080;
	*(volatile unsigned int *)0xa000008 = 0x2080;

	*(volatile unsigned int *)0xa800008 |= 0x4;		// Start timer

	// Set LCD for 32hz
	data 								= *(volatile unsigned int *)0xd000000;
	data 								&= ~0x7f;
	data 								|= 0x68;
	*(volatile unsigned int *)0xd000000	= data;

	srand(VsyncCount);

	for (loop = 0; loop < MAXCLAYS; loop++)
	{
		LaunchClay(loop);
	}

    while (1)
    {
		ClearScreen();

		for (loop = 0; loop < MAXCLAYS; loop++)
		{
			MoveClay(loop);
		}

		DrawTargets();
		PrintScores();

		BlitImage(12, 28, 8, 4, Gun[Pos]);

        BlitScreen();

		VSync();

		Key = ReadPad();

		Pos = 1;

		if (Key & INPUT_LEFT)
		{
			if (FALSE == FireLeft)
			{
				for (loop = 0; loop < MAXCLAYS; loop++)
				{
					if (Clays[loop].x > 6 && Clays[loop].x < 14)
					{
						Clays[loop].hit = TRUE;
						ClaysHit++;

						break;
					}
				}

				Pos = 0;

				FireLeft = TRUE;
			}
		}

		else
		{
			FireLeft = FALSE;
		}

		if (Key & INPUT_RIGHT)
		{
			if (FALSE == FireRight)
			{
				for (loop = 0; loop < MAXCLAYS; loop++)
				{
					if (Clays[loop].x > 14 && Clays[loop].x < 22)
					{
						Clays[loop].hit = TRUE;
						ClaysHit++;

						break;
					}
				}

				Pos	= 2;

				FireRight = TRUE;
			}
		}

		else
		{
			FireRight = FALSE;
		}
    }

    return 0;
}

BYTE ReadPad()
{
    BYTE    buttons = INTRAWSTATUS;
    BYTE    Value   = INPUT_NONE;

    if (buttons & UP)
    {
        Value |= INPUT_UP;
    }

    if (buttons & DOWN)
    {
        Value |= INPUT_DOWN;
    }

    if (buttons & RIGHT)
    {
        Value |= INPUT_RIGHT;
    }

    if (buttons & LEFT)
    {
        Value |= INPUT_LEFT;
    }

    if (buttons & FIRE)
    {
        Value |= INPUT_FIRE;
    }

    return Value;
}

DWORD BlitScreen()
{
    DWORD   *vidptr = LCDBUFF;
    int     loop;

    for (loop = 0; loop < 32; loop++)
	{
        *vidptr++ = OffScreen[loop];
	}

    return ERR_NOERROR;
}

DWORD ClearScreen()
{
    DWORD   *vidptr;
    int     loop;

    vidptr = (DWORD *)OffScreen;

    for (loop = 0; loop < 32; loop++)
    {
        vidptr[loop] = 0;
    }

    return ERR_NOERROR;
}

DWORD BlitImage(int x, int y, int width, int height, const char *image)
{
    long    innerloop;
    long    outerloop;
    long    tmpx        = x;
    char    pixel;
    char    *display;

    width   /= 8;
    display = (char *)(OffScreen) + (y * 4) + (x / 8);

    for (outerloop = 0; outerloop < height; outerloop++)
    {
        for (innerloop = 0; innerloop < width; innerloop++)
        {
            (*display)  |= ((*image) << (x % 8));

            if ((x % 8) != 0)
            {
                *(display + 1) |= ((*image) >> (8 - (x % 8)));
            }

            image++;
            display++;
            x++;
        }

        display += 4 - width;
        x       = tmpx;
    }

    return ERR_NOERROR;
}

void  LaunchClay(BYTE clay)
{
	BYTE direction 				= rand() & 1;

	Clays[clay].y 				= CLAYY * 16;
	Clays[clay].rise   			= rand() & 15;
    Clays[clay].hit				= FALSE;

	Clays[clay].delay		= (rand() & 3) + clay + 1;

	if (0 == direction)
	{
		Clays[clay].x 			= 0;
		Clays[clay].direction 	= 1;
	}

	else
	{
		Clays[clay].x 			= 28;
		Clays[clay].direction 	= -1;
	}
}

void  MoveClay(BYTE clay)
{
	if (Clays[clay].delay > 0)
	{
		Clays[clay].delay--;
	}

	else
	{
		Clays[clay].x += Clays[clay].direction;
		Clays[clay].y -= Clays[clay].rise;

		if (Clays[clay].x < 0 || Clays[clay].x >= SCREENWIDTH - 4)
		{
			LaunchClay(clay);
		}
	}

	if (0 == Clays[clay].delay)
	{
		if (TRUE == Clays[clay].hit)
		{
			BlitImage(Clays[clay].x, Clays[clay].y / 16, 8, 2, Explode);
		}

		else
		{
			BlitImage(Clays[clay].x, Clays[clay].y / 16, 8, 2, ClayImage);
		}
	}
}

void DrawTargets()
{
    BYTE    Target1y 	= 24;
    BYTE    Target2y 	= 24;
	long	X1 			= 5;
	long	X2 			= 26;
	long	loop;

	for (loop = 0; loop < MAXCLAYS; loop++)
	{
		if (Clays[loop].x < 14 && Clays[loop].x > 6 && FALSE == Clays[loop].hit)
		{
			if (Clays[loop].x > X1)
			{
				X1			= Clays[loop].x;
				Target1y 	= Clays[loop].y / 16 - 1;
			}
		}

		if (Clays[loop].x > 14 && Clays[loop].x < 26 && FALSE == Clays[loop].hit)
		{
			if (Clays[loop].x < X2)
			{
				X2			= Clays[loop].x;
				Target2y 	= Clays[loop].y / 16 - 1;
			}
		}
	}

	BlitImage(10, Target1y, 8, 4, Target);
	BlitImage(18, Target2y, 8, 4, Target);
}

void PrintScores()
{
	long score = ClaysHit;

//    BlitImage(2, 26, 8, 5, Numbers[score]);

    score = TotalScore + score;

    if (score > 99)
    {
        score = 99;
    }

	if (score >= 90)
	{
		BlitImage(22, 26, 8, 5, Numbers[9]);

		score -= 90;
	}

	if (score >= 80)
	{
		BlitImage(22, 26, 8, 5, Numbers[8]);

		score -= 80;
	}

	if (score >= 70)
	{
		BlitImage(22, 26, 8, 5, Numbers[7]);

		score -= 70;
	}

	if (score >= 60)
	{
		BlitImage(22, 26, 8, 5, Numbers[6]);

		score -= 60;
	}

	if (score >= 50)
	{
		BlitImage(22, 26, 8, 5, Numbers[5]);

		score -= 50;
	}

	if (score >= 40)
	{
		BlitImage(22, 26, 8, 5, Numbers[4]);

		score -= 40;
	}

	if (score >= 30)
	{
		BlitImage(22, 26, 8, 5, Numbers[3]);

		score -= 30;
	}

	if (score >= 20)
	{
		BlitImage(22, 26, 8, 5, Numbers[2]);

		score -= 20;
	}

	if (score >= 10)
	{
		BlitImage(22, 26, 8, 5, Numbers[1]);

		score -= 10;
	}

	BlitImage(26, 26, 8, 5, Numbers[score]);
}

void timer0_handler()
{
	VsyncCount++;
}

void timer2_handler()
{
}

void irq_handler()
{
	register int status, i;

	status = *(volatile unsigned int *)0xa000000;
	status &= *(volatile unsigned int *)0xa000008;
	status &= ~0x2040;			// clear FIQ bits

	for (i = 13; i >= 0; i--)
	{
		if ((status & (1 << i)) && IntTable[i])
		{
			(IntTable[i])();
		}
	}

	*(volatile unsigned int *)0xa000010 = status;
}

void fiq_handler()
{
	register int status;

	status = *(volatile unsigned int *)0xa000000;
	status &= 0x2000;					// FIQ bit

	if (IntTable[13])
	{
		(IntTable[13])();
	}

	*(volatile unsigned int *)0xa000010 = status;
}

DWORD VSync()
{
	int vert = VsyncCount;

	while (vert == VsyncCount);

	return ERR_NOERROR;
}

void printf(char* ptr)
{
    while (*ptr != 0)
    {
		myputch(*ptr++);
    }
}


