// **************************************************************************
// *				 Sporting Clays for the Playstation						*
// *					   (C) 1999 Charles Doty                           	*
// *	 	  System Header file contains system related code				*
// **************************************************************************

#ifndef __INPUT_H
#define __INPUT_H

#include "defines.h"

#include <sys/file.h>
#include <libapi.h>

#define EVENT_IOE					0
#define EVENT_ERROR					1
#define EVENT_TIMEOUT				2
#define EVENT_NEWCARD				3

#define PRESENT_CARD_FORMATTED	  	0
#define PRESENT_CARD_BAD		  	1
#define PRESENT_CARD_NONE		  	2
#define PRESENT_CARD_UNFORMATTED  	3

#define NEW_CARD_FORMATTED		  	4
#define NEW_CARD_BAD			  	5
#define NEW_CARD_NONE			  	6
#define NEW_CARD_UNFORMATTED	  	7

typedef struct
{
	char	Magic[2];			// Identification
	char	NumIcons;			// 0x10 + Number of icons
	char	NumBlocks;			// Number of blocks
	char	Title[64];			// SJIS title
	char	reserve[28];		// Reserved
	char	Clut[32];			// 16 color clut
	char	Icon[3][128];	    // 16 x 16 4 bit icons (3 max)
} MemeCardHeader;

DWORD FileRead(char *filename, BYTE *buffer);

DWORD MemoryCardInitialize();
  // Identifies if memory cards are present, ands sets up for use.

int GetCardStatus();
  // Returns the status of the memory card.

int GetSoftwareEvent();
  // Get software events.

int GetHardwareEvent();
  // Get hardware events.

DWORD ClearSoftwareEvents();
  // Clear software events.

DWORD ClearHardwareEvents();
  // Clear hardware events.

#endif
