// **************************************************************************
// *				 Sporting Clays for the Playstation						*
// *					   (C) 1999 Charles Doty                           	*
// *	 	  System Source file contains system related code				*
// **************************************************************************

#include "system.h"

BOOL	CardPresent = FALSE;	// Is there a memory card present?
long	Event0;
long	Event1;
long	Event2;
long	Event3;
long	Event10;
long	Event11;
long	Event12;
long	Event13;

DWORD FileRead(char *filename, BYTE *buffer)
{
#ifdef COMPUTER
    long Handle;
#endif
    char file[128];

    if (NULL == filename || NULL == buffer)
    {
#ifdef DEBUG
		printf("Bad Parameters to FileRead\n");
#endif

    	return ERR_FILEERROR;
    }

#ifdef COMPUTER    
    Handle = open(filename, O_RDONLY);

    if (-1 == Handle)
    {
#ifdef DEBUG
		printf("Unable to open file %s in FileRead\n", filename);
#endif

		return ERR_FILEERROR;
    }

    read(Handle, buffer, 256 * 1024);

    close(Handle);
#else
    if (0 == CdReadFile(filename, buffer, 0))
    {    
#ifdef DEBUG
		printf("Unable to open file %s in FileRead\n", filename);
#endif

		return ERR_FILEERROR;
    }

    CdReadSync(0);
#endif
}

DWORD MemoryCardInitialize()
{
	CardPresent = FALSE;

  	EnterCriticalSection();
  	InitCARD(0);
  	ExitCriticalSection();
  	StartCARD();
  	_bu_init();

  	EnterCriticalSection();
  	Event0 	= OpenEvent(SwCARD, EvSpIOE, EvMdNOINTR, NULL) ;
  	Event1 	= OpenEvent(SwCARD, EvSpERROR, EvMdNOINTR, NULL) ;
  	Event2 	= OpenEvent(SwCARD, EvSpTIMOUT, EvMdNOINTR, NULL) ;
  	Event3 	= OpenEvent(SwCARD, EvSpNEW, EvMdNOINTR, NULL) ;
  	Event10 = OpenEvent(HwCARD, EvSpIOE, EvMdNOINTR, NULL) ;
  	Event11 = OpenEvent(HwCARD, EvSpERROR, EvMdNOINTR, NULL) ;
  	Event12 = OpenEvent(HwCARD, EvSpTIMOUT, EvMdNOINTR, NULL) ;
  	Event13 = OpenEvent(HwCARD, EvSpNEW, EvMdNOINTR, NULL) ;
  	ExitCriticalSection();

  	EnableEvent(Event0);
  	EnableEvent(Event1);
  	EnableEvent(Event2);
  	EnableEvent(Event3);
  	EnableEvent(Event10);
  	EnableEvent(Event11);
  	EnableEvent(Event12);
  	EnableEvent(Event13);

	return ERR_NOERROR;
}

DWORD MemoryCardClose()
{
  	StopCARD();

  	DisableEvent(Event0);
  	DisableEvent(Event1);
  	DisableEvent(Event2);
  	DisableEvent(Event3);
  	DisableEvent(Event10);
  	DisableEvent(Event11);
  	DisableEvent(Event12);
  	DisableEvent(Event13);

  	CloseEvent(Event0);
  	CloseEvent(Event1);
  	CloseEvent(Event2);
  	CloseEvent(Event3);
  	CloseEvent(Event10);
  	CloseEvent(Event11);
  	CloseEvent(Event12);
	CloseEvent(Event13);

	return ERR_NOERROR;
}

int GetCardStatus()
{
	int	RetVal;

  	VSync(3);
 	ClearSoftwareEvents();
  	_card_info(0);

  	RetVal = GetSoftwareEvent();

  	switch (RetVal)
  	{
    	case EVENT_IOE:
            return PRESENT_CARD_FORMATTED;			// change to PRESENT_CARD_FORMATTED = 0

            break;

    	case EVENT_ERROR:
            return PRESENT_CARD_BAD;				// change to PRESENT_CARD_BAD = 1

            break;

    	case EVENT_TIMEOUT:
            return PRESENT_CARD_NONE;				// change to PRESENT_CARD_NONE = 2

            break;
  	}

  	ClearHardwareEvents();
  	_card_clear(0);

  	RetVal = GetHardwareEvent();

  	ClearSoftwareEvents();
  	_card_load(0);

  	RetVal = GetSoftwareEvent();

  	switch (RetVal)
  	{
    	case EVENT_IOE:
	  		return NEW_CARD_FORMATTED;

          	break;

    	case EVENT_ERROR:
	  		return NEW_CARD_BAD;

          	break;

    	case EVENT_TIMEOUT:
	  		return NEW_CARD_NONE;

        	break;

    	case EVENT_NEWCARD:
	  		return NEW_CARD_UNFORMATTED;

        	break;
 	}

	return -1;
}

int GetSoftwareEvent()
{
 	int TimeOut = 0;

  	while (TimeOut++ < 200000)
  	{
  		if (TRUE == TestEvent(Event0))
  		{
  			return EVENT_IOE;
  		}

    	if (TRUE == TestEvent(Event1))
    	{
    		return EVENT_ERROR;
    	}

    	if (TRUE == TestEvent(Event2))
    	{
    		return EVENT_TIMEOUT;
    	}

    	if (TRUE == TestEvent(Event3))
    	{
    		return EVENT_NEWCARD;
    	}
	}
}

int GetHardwareEvent()
{
 	int TimeOut = 0;

  	while (TimeOut++ < 200000)
  	{
  		if (TRUE == TestEvent(Event10))
  		{
  			return 0;
  		}

    	if (TRUE == TestEvent(Event11))
    	{
    		return 1;
    	}

    	if (TRUE == TestEvent(Event12))
    	{
    		return 2;
    	}

    	if (TRUE == TestEvent(Event13))
    	{
    		return 3;
    	}
	}
}

DWORD ClearSoftwareEvents()
{
	TestEvent(Event0);
  	TestEvent(Event1);
  	TestEvent(Event2);
  	TestEvent(Event3);

	return ERR_NOERROR;
}

DWORD ClearHardwareEvents()
{
	TestEvent(Event10);
  	TestEvent(Event11);
  	TestEvent(Event12);
  	TestEvent(Event13);

	return ERR_NOERROR;
}

