// **************************************************************************
// *				 Sporting Clays for the Playstation						*
// *					   (C) 1999 Charles Doty                           	*
// *	 Sound Source file contains sound playing and loading code			*
// **************************************************************************

#include "sound.h"

long	Vab;
BOOL	SoundsLoaded;

DWORD SoundInitialize()
{
	SsInit();
	SsSetTickMode(SS_TICK60);
	SsStart();

	SoundsLoaded = FALSE;

	return ERR_NOERROR;
}

DWORD LoadSounds(char *sound)
{
	char filename[FILENAMELEN];

	strcpy(filename, DIRECTORY);
	strcat(filename, sound);
	strcat(filename, ".vh");

	if (ERR_FILEERROR == FileRead(filename, VHADDRESS))
	{
       	return ERR_INITERROR;
   	}

	strcpy(filename, DIRECTORY);
	strcat(filename, sound);
	strcat(filename, ".vb");

	if (ERR_FILEERROR == FileRead(filename, VBADDRESS))
	{
       	return ERR_INITERROR;
   	}

	Vab = SsVabTransfer((BYTE *)VHADDRESS, (BYTE *)VBADDRESS, -1, SS_WAIT_COMPLETED);

	if (Vab < 0)
	{
#ifdef DEBUG
		printf("Unable to load sounds in LoadSounds. %d\n", Vab);
#endif

		return	ERR_INITERROR;
	}

	SoundsLoaded = TRUE;

	return ERR_NOERROR;
}

DWORD PlaySound(short sound, short note, short leftvol, short rightvol)
{
	if (FALSE == SoundsLoaded)
	{
#ifdef DEBUG
		printf("Sounds not loaded prior to playing a sound in PlaySound.\n");
#endif

		return ERR_PLAYERROR;
	}

	if (-1 == SsUtKeyOn(Vab, sound, 0, note, 0, leftvol, rightvol))
	{
#ifdef DEBUG
		printf("Unable to play sound in PlaySound.\n");
#endif

		return ERR_PLAYERROR;
	}

	return ERR_NOERROR;
}
