// **************************************************************************
// *				 Sporting Clays for the Playstation						*
// *					   (C) 1999 Charles Doty                          	*
// *	 	   3D Header Source file contains 3D related code				*
// **************************************************************************

#ifndef __SCENE3D_H
#define __SCENE3D_H

#include "defines.h"

#include <libetc.h>
#include <libgte.h>
#include <libgpu.h>
#include <libgs.h>
#include <libmath.h>

#define MAXPOLYGONS 200                     // maximum amount of polygons
#define ZBUFFERSIZE 1024                    // depth of Z Buffer (OT)

typedef struct
{
	SVECTOR v0, v1, v2;
} Vertices;

typedef struct
{
    long		Primatives;     			// Primatives in object
	Vertices    Vertex[MAXPOLYGONS];
	POLY_GT3 	Primative[2][MAXPOLYGONS];
} ObjectDesc;

typedef struct
{
    VECTOR          Position;				// Position
    SVECTOR         Rotation;				// Rotation
    VECTOR          Scale;					// Position
    ObjectDesc      Object[MAXFRAMES];		// Object
    RECT            ScreenRect;     		// Rectange occupied on the screen
	BOOL			Used;					// Is object in use?
	long			CurrentFrame;			// Current Frame
} Object3D;

DWORD Scene3DInitialize();
  // Initializes the 3D Scene

DWORD AddObject(u_long *object, WORD *ObjectID, struct POS *position, struct ROT *rotation,
	struct SCALE *scale);
  // Adds object to scene

DWORD MoveObject(WORD ObjectID, struct POS *position);
  // Changes the position of a 3D Object

DWORD RotateObject(WORD ObjectID, struct ROT *rotation);
  // Changes the rotation of a 3D Object

DWORD SetObjectFrame(WORD ObjectID, long frame);
  // Sets objects current frame

BOOL CheckIntersection(WORD ObjectID, short x, short y, short range, short *distance, short *xdir,
	short *ydir);
  // Checks object intersection with a point

BOOL CheckFloor(WORD ObjectID, short y);
  // Checks object intersection with scene defined floor

BOOL CheckScreen(WORD ObjectID);
  // Checks if object has left the screen

DWORD Render(long ActiveBuffer);
  // Renders the 3D Objects

DWORD LoadTIM(u_long *TIM);
  // Loads TIM related to 3d graphics

#endif
