// **************************************************************************
// *				 Sporting Clays for the Playstation						*
// *					   (C) 1999 Charles Doty                           	*
// *	 		   Input Source file contains input code					*
// **************************************************************************

#ifndef __INPUT_H
#define __INPUT_H

#include "defines.h"
#include <libapi.h>
#include <libetc.h>
#include <libgun.h>
#include <libgte.h>
#include <libgpu.h>
#include <libgs.h>

#define MOUSE				1
#define NEGCON				2
#define KONAMI_GUN			3
#define PAD					4
#define NAMCO_GUN			6
#define ANALOG				7
#define MULTITAP			8

#define MAXBUFFERSHOTS		20	// Maximum shots in the gun shot buffer

#define KONAMI_TRIGGER		0x8000
#define KONAMI_START		0x0008
#define GUNCON_TRIGGER		0x2000
#define GUNCON_START		0x0008
#define MOUSE_LEFTBUTTON	0x0800
#define MOUSE_RIGHTBUTTON	0x0400
#define PAD_SELECT			0x0001
#define PAD_START			0x0008
#define PAD_UP				0x0010
#define PAD_DOWN			0x0040
#define PAD_LEFT			0x0080
#define PAD_RIGHT			0x0020
#define PAD_X				0x4000

typedef struct
{
	WORD			Buttons;	// Buttons on the gun
	BYTE			X;			// X position of the gun
	BYTE			Section;	// The section the gun is in
	BYTE			Y;			// Y position of the gun
	BYTE			Pad;		// Pad ID.
} GunCon;

typedef struct
{
	WORD			Buttons;	// Buttons on the mouse
	signed char		X;			// X position of the mouse
	signed char		Y;			// Y position of the mouse
} Mouse;

typedef struct
{
	BYTE			Status;		// Status of controller. (0xFF is bad data)
	BYTE			Format;		// Format of the data retrieved. (0xF0 is the mask for
								// the controller type)
	GunCon			Data;		// Data from the pad, upto 6 bytes.
} MultiControl;

typedef struct
{
	MultiControl	Data[4];   	// Can return upto four sets of data.
} MultiTap;

typedef struct
{
	WORD 	Buttons;         	// Buttons on the controller
	BYTE  	RightX;				// X position of right controller
    BYTE  	RightY;				// Y position of right controller
    BYTE  	LeftX;              // X position of left controller
    BYTE  	LeftY;				// X position of left controller
} Analog;

typedef struct					// Structure must be 34 byes long
{
	BYTE			Status;		// Status of controller. (0xFF is bad data)
	BYTE			Format;		// Format of the data retrieved. (0xF0 is the mask for
								// the controller type)
	union
	{
		WORD		pad;		// Normal controller pad
		GunCon		gun;		// Namco gun
		Mouse		mouse;		// Mouse data
		MultiTap	multitap;	// MultiTap data, included to ensure structure comes out correct.
		Analog		analog;		// Analog data
	} InputType;
} ControllerData;

typedef struct GunHV
{
	WORD			YTiming;	// Y timing value for the shot
	WORD			XTiming;	// X timing value for the shot
} GunHV;

typedef struct
{
	char			Unused;		// Unused
	char			Count;		// Number of shots
	GunHV			Shots[MAXBUFFERSHOTS];// Shot positions
} Gun;

typedef struct
{
	DWORD			Type;		// Type of controller
	DWORD			Buttons;	// Button flags
	DWORD			Controller;	// Direction flags for the controller
	long			X;			// Relative x position of the controller
	long			Y;			// Relative y position of the controller
} InputStruct;

DWORD InputInitialize();
  // Initialize input system.

DWORD ReadInput(InputStruct *Input, DWORD gun);
  // Reads input

DWORD SetPadMoveValues(DWORD x, DWORD y);
  // Sets pad movement resolution

DWORD ReadMouse(InputStruct *Input, DWORD controller);
  // Read mouse specific function

DWORD ReadPad(InputStruct *Input, DWORD controller);
  // Read pad specific function

DWORD ReadAnalog(InputStruct *Input, DWORD controller);
  // Read analog specific function

DWORD ReadKonamiGun(InputStruct *Input, DWORD controller);
  // Read Konami gun specific function

DWORD ReadNamcoGun(InputStruct *Input, DWORD controller);
  // Read Namco gun specific function

DWORD SetMouseLimits(long x1, long y1, long x2, long y2);
  // Sets the area that the mouse can move in.

DWORD CloseCurrentDevice();
  // Closes currently opened device

DWORD SetInputMousePosition(long x, long y);
  // Sets mouse position

DWORD Convert2SJIS(BYTE *string, BYTE *dest);
  // Converts string from ASCII to SJIS.

#endif
