// **************************************************************************
// *				 Sporting Clays for the Playstation						*
// *					   (C) 1999 Charles Doty                           	*
// *	 		Game Header file contains game related code					*
// **************************************************************************

#ifndef __GAME_H
#define	__GAME_H

#include <sys/types.h>
#include "scene.h"
#include <libgte.h>
#include <libmath.h>
#include <kernel.h>

typedef struct
{
	WORD			ObjectID;	// ID of object in Scene3D
	struct POS		Position;   // Object position
	struct POS		Init;   	// Object Initial position
	struct ROT		Rotation;	// Object rotation
	struct SCALE	Scale;      // Object scale
	float			Velx;		// Object velocity x
	float			Vely;		// Object velocity y
	float			Velz;		// Object velocity z
	short			Speed;		// Object speed
	short			Delay;		// Object delay
	long			AngleY;		// Y angle of launch
	long			AngleZ;		// Z angle of launch
	BOOL			Rabbit;		// Is this a rabbit?
	BOOL			Remove;		// Remove object when the ground is hit?
	BOOL			Water;		// Will the object hit water?
	BOOL			Hit;		// Was Object Hit?
	BOOL			Flying;		// Is the object flying
} Clay;

DWORD GameInitialize();
  // Initialize game

DWORD Run(WORD scene);
  // Runs game

DWORD LoadScene(WORD scene, BOOL Load);
  // Loads scene description from disk

DWORD AnimateClay(short clay);
  // Calculates the clays flight path

DWORD ReadModel(char *model, u_long *address, BOOL loadtexture);
  // Read a TMD and TIM based on a model name

DWORD AddTIM(char *name);
  // Adds TIM to VRAM

BOOL CheckHit(short clay);
  // Checks if a specified clay was hit.

DWORD PrintScores();
  // Prints the results of the round.

DWORD WaitForStart(BOOL PullSound);
  // Prints message, waits for start

#endif

