// **************************************************************************
// *                 Sporting Clays for the Playstation                     *
// *					   (C) 1999 Charles Doty                           	*
// *	 		 Game Source file contains game related code				*
// **************************************************************************

#include "game.h"
#include "input.h"

#define MAXSCENES	3
#define MAXROUNDS	5
#define RANGE		10
#define INNERRANGE	2

#define GUN_SND		0
#define LAUNCH_SND	1
#define EMPTY_SND	2
#define MISS_SND	3
#define HIT_SND		6
#define SPLASH_SND	9
#define PULL_SND	10

#define EMPTY_NOTE	40
#define GUN_NOTE	40
#define LAUNCH_NOTE	35
#define SPLASH_NOTE 52
#define VOICE_NOTE  52
#define PULL_NOTE  	40

#define MAXSOUNDS	3

#define MOUSESIZE	16

#define RABBITMULTIPLY	1.0

Clay 		Clays[2];
WORD		NumClays;
WORD		ClaysHit[MAXPLAYERS];
WORD		ClaysTotal[MAXPLAYERS];
WORD 		Player;
char		Image[FILENAMELEN];
short		Floor;
short		ZLimit;								// ZLimit to consider clay hitting the ground. Scene specific.
short		ZOffscreen;							// ZLimit to consider clay Offscreen. Scene specific.
short		Shots;								// Number of shots taken
BOOL		OnReport;
BOOL		Shot[2];							// Draw shot (miss) 1/2
float		Flight[2];
float		Flight2[2];
SceneStruct *Scene;
WORD		NumRounds;
InputStruct	Input;

extern	char SubDir[FILENAMELEN];

inline long ConvertToPlayStation(long degree)
{
	return degree * ONE / 360;
}

DWORD GameInitialize()
{
	char 	filename[FILENAMELEN];

	if (ReadModel("white", (u_long *)TMDADDRESS1, TRUE) != ERR_NOERROR)
	{
		return ERR_INITERROR;
	}

	if (ReadModel("grey", (u_long *)TMDADDRESS2, TRUE) != ERR_NOERROR)
	{
		return ERR_INITERROR;
	}

	if (ReadModel("orange", (u_long *)TMDADDRESS3, TRUE) != ERR_NOERROR)
	{
		return ERR_INITERROR;
	}

	if (ReadModel("whitehit", (u_long *)TMDADDRESS4, FALSE) != ERR_NOERROR)
	{
		return ERR_INITERROR;
	}

	if (ReadModel("greyhit", (u_long *)TMDADDRESS5, FALSE) != ERR_NOERROR)
	{
		return ERR_INITERROR;
	}

	if (ReadModel("oranghit", (u_long *)TMDADDRESS6, FALSE) != ERR_NOERROR)
	{
		return ERR_INITERROR;
	}

	if (ReadModel("whiteedg", (u_long *)TMDADDRESS7, FALSE) != ERR_NOERROR)
	{
		return ERR_INITERROR;
	}

	if (ReadModel("greyedg", (u_long *)TMDADDRESS8, FALSE) != ERR_NOERROR)
	{
		return ERR_INITERROR;
	}

	if (ReadModel("orangedg", (u_long *)TMDADDRESS9, FALSE) != ERR_NOERROR)
	{
		return ERR_INITERROR;
	}

	if (AddTIM("shot") != ERR_NOERROR)
	{
		return ERR_INITERROR;
	}

	LoadShot(TIMADDRESS, 0);
	LoadShot(TIMADDRESS, 1);

	strcpy(filename, DIRECTORY);
	strcat(filename, "cursor.tim");

	if (ERR_FILEERROR == FileRead(filename, TIMADDRESS))
	{
        return ERR_FILEERROR;
    }

	LoadMouse(TIMADDRESS);
	SetMouseLimits(MOUSESIZE / 2, MOUSESIZE / 2, SCREENWIDTH - MOUSESIZE / 2, SCREENHEIGHT -
		MOUSESIZE / 2);

	LoadSounds("clays");

	return ERR_NOERROR;
}

DWORD Run(WORD scene)
{
	char	filename[80];
    short	sound;
    WORD	loop;

	NumRounds 	= 0;
    Input.X		= SCREENWIDTH / 2;
    Input.Y		= SCREENHEIGHT / 2;

	for (loop = 0; loop < MAXPLAYERS; loop++)
	{
		ClaysHit[loop] = 0;
	}

	for (loop = 0; loop < MAXPLAYERS; loop++)
	{
		ClaysTotal[loop] = 0;
	}

	Player	 = 0;

	SetInputMousePosition(Input.X, Input.Y);
	SetMousePosition(Input.X - MOUSESIZE / 2, Input.Y - MOUSESIZE / 2);
    SetPadMoveValues(4, 4);

    DrawTextString("SPORTING CLAYS.", 3, 3);
    DrawTextString("BY CHARLES DOTY.", 2, 4);
    DrawTextString("CDOTY@NETZERO.NET", 1, 5);

    sprintf(filename, "%s%s%s", DIRECTORY, "00\\", "scene1.tim");

    if (ERR_FILEERROR == FileRead(filename, TIMADDRESS))
    {
        return ERR_INITERROR;
    }

    // Loads TIM and sets up sprites
    LoadPicture((u_long *)TIMADDRESS);

    WaitForStart(FALSE);

	LoadScene(scene, TRUE);

	// Flip display buffers
	while (1)
	{
        ReadInput(&Input, 0);

		if (Input.Type != CON_NONE)
		{
			if (CON_GUN == Input.Type)
			{
			}

			else if (CON_MOUSE == Input.Type || CON_PAD == Input.Type)
			{
				SetMousePosition(Input.X - MOUSESIZE / 2, Input.Y - MOUSESIZE / 2);
			}

			if ((BUT_TRIGGER & Input.Buttons) != 0)
			{
				if (Shots < 2)
				{
					PlaySound(GUN_SND, GUN_NOTE, 127, 127);

					if (Clays[0].Position.z <= Clays[1].Position.z)
					{
						if (FALSE == CheckHit(0))
						{
							if (FALSE == CheckHit(1))
							{
								Shot[Shots] = TRUE;
								SetShotPosition(Input.X - SHOTSIZE / 2, Input.Y - SHOTSIZE / 2,
									Shots);

								sound = rand() % MAXSOUNDS;

								PlaySound(MISS_SND + sound, VOICE_NOTE, 127, 127);
							}
						}
					}

					else
					{
						if (FALSE == CheckHit(1))
						{
							if (FALSE == CheckHit(0))
							{
								Shot[Shots] = TRUE;
								SetShotPosition(Input.X - SHOTSIZE / 2, Input.Y - SHOTSIZE / 2,
									Shots);

								sound = rand() % MAXSOUNDS;

								PlaySound(MISS_SND + sound, VOICE_NOTE, 127, 127);
							}
						}
					}

					Shots++;
				}

				else
				{
					PlaySound(EMPTY_SND, EMPTY_NOTE, 127, 127);
				}
			}
		}

		AnimateClay(0);
		AnimateClay(1);

		Flip();

		if (FALSE == Clays[0].Flying && FALSE == Clays[1].Flying && Clays[1].Delay <= 0)
		{
			if (FALSE == Clays[0].Remove)
			{
				RemoveObject(Clays[0].ObjectID);
			}

			if (FALSE == Clays[1].Remove)
			{
				RemoveObject(Clays[1].ObjectID);
			}

			Flip();

			NumRounds++;

			if (NumRounds >= MAXROUNDS)
			{
				PrintScores();

				for (loop = 0; loop < MAXPLAYERS; loop++)
				{
					ClaysHit[loop] = 0;
				}

				Player	 = 0;

				scene++;

				if (scene > MAXSCENES)
				{
					scene = 1;
				}

				NumRounds = 0;

				LoadScene(scene, TRUE);
			}

			else
			{
				LoadScene(scene, FALSE);
			}
		}
	}

	return ERR_NOERROR;
}

DWORD LoadScene(WORD scene, BOOL Load)
{
	char	filename[80];
	BYTE	*sceneptr;
	short	number1;
	short	number2;
	u_long	*address;
	u_long	*address2;
	u_long	*address3;
	short	volleft;
	short	volright;

	Flight[0]	= 0.0f;
	Flight[1]	= 0.0f;
	Flight2[0]	= 0.0f;
	Flight2[1]	= 0.0f;
    Shot[0]		= FALSE;
    Shot[1]		= FALSE;
	Shots		= 0;

	if (TRUE == Load)
	{
        sprintf(filename, "%s%sscene%i.scn", DIRECTORY, SubDir, scene);

		if (ERR_FILEERROR == FileRead(filename, SCENEADDRESS))
		{
			return ERR_FILEERROR;
		}
	}

	sceneptr	= (BYTE *)SCENEADDRESS;

	if (*(WORD *)sceneptr != VERSION)
	{
#ifdef DEBUG
		printf("Bad scene version in LoadScene.\n");
#endif

		return ERR_FILEERROR;
	}

	sceneptr 	+= 2;

	NumClays	= *(WORD *)sceneptr;
	sceneptr	+=	 2;

	strcpy(Image, (char *)sceneptr);
	sceneptr	+= FILENAMELEN;

	Floor		= *(short *)sceneptr;
	sceneptr	+=	 2;

	ZLimit		= *(short *)sceneptr;
	sceneptr	+=	 2;

	ZOffscreen	= *(short *)sceneptr;
	sceneptr	+=	 2;

	OnReport	= *(short *)sceneptr;
	sceneptr	+=	 2;

	Scene 		= (SceneStruct *)sceneptr;

    if (TRUE == Load)
    {
    	sprintf(filename, "%s%s%s", DIRECTORY, SubDir, Image);

		if (ERR_FILEERROR == FileRead(filename, TIMADDRESS))
		{
        	return ERR_INITERROR;
    	}

    	// Loads TIM and sets up sprites
    	LoadPicture((u_long *)TIMADDRESS);

		Flip();
    }

    if (NumClays > 2)
    {
    	number1	= rand() % NumClays;
    }

    else
    {
    	number1 = 0;
    }


    Clays[0].Position.x = Scene[number1].Init.x;
    Clays[0].Position.y = Scene[number1].Init.y;
    Clays[0].Position.z = Scene[number1].Init.z;
    Clays[0].Init.x 	= Scene[number1].Init.x;
    Clays[0].Init.y 	= Scene[number1].Init.y;
    Clays[0].Init.z 	= Scene[number1].Init.z;
    Clays[0].Rotation.x = Scene[number1].Rot.x;
    Clays[0].Rotation.y = Scene[number1].Rot.y;
    Clays[0].Rotation.z = Scene[number1].Rot.z;
    Clays[0].Scale.x 	= Scene[number1].Scale.x;
    Clays[0].Scale.y 	= Scene[number1].Scale.y;
    Clays[0].Scale.z 	= Scene[number1].Scale.z;
 	Clays[0].Speed		= Scene[number1].Speed;
 	Clays[0].Delay		= Scene[number1].Delay;
 	Clays[0].AngleY		= Scene[number1].AngleY;
 	Clays[0].AngleZ		= Scene[number1].AngleZ;
 	Clays[0].Rabbit		= Scene[number1].Rabbit;
 	Clays[0].Remove		= Scene[number1].Remove;
 	Clays[0].Water		= Scene[number1].Water;
	Clays[0].Velx		= Scene[number1].Speed * rsin(ConvertToPlayStation(Scene[number1].AngleY)) / ONE;
	Clays[0].Vely		= Scene[number1].Speed * rsin(ConvertToPlayStation(Scene[number1].AngleZ)) / ONE;
	Clays[0].Velz		= Scene[number1].Speed * rcos(ConvertToPlayStation(Scene[number1].AngleZ)) / ONE;
 	Clays[0].Hit		= FALSE;

    switch (Scene[number1].Color)
    {
    	case CC_WHITE:
    		address		= (u_long *)TMDADDRESS1;
    		address2	= (u_long *)TMDADDRESS4;
    		address3	= (u_long *)TMDADDRESS7;

    		break;

    	case CC_GREY:
    		address		= (u_long *)TMDADDRESS2;
    		address2	= (u_long *)TMDADDRESS5;
    		address3	= (u_long *)TMDADDRESS8;

    		break;

    	case CC_ORANGE:
    		address		= (u_long *)TMDADDRESS3;
    		address2	= (u_long *)TMDADDRESS6;
    		address3	= (u_long *)TMDADDRESS9;

    		break;
	}

    AddObject(address, &Clays[0].ObjectID, &Clays[0].Position, &Clays[0].Rotation, &Clays[0].Scale);
    AddAnimation(address2, Clays[0].ObjectID, 1);
    AddAnimation(address3, Clays[0].ObjectID, 2);

   	Clays[0].Flying = TRUE;
   	Clays[0].Delay 	= 0;

    if (NumClays > 2)
    {
		number2 = number1;

    	while (number2 == number1)
    	{
    		number2	= rand() % NumClays;
    	}
    }

    else
    {
    	number2 = 1;
    }

    Clays[1].Position.x = Scene[number2].Init.x;
    Clays[1].Position.y = Scene[number2].Init.y;
    Clays[1].Position.z = Scene[number2].Init.z;
    Clays[1].Init.x 	= Scene[number2].Init.x;
    Clays[1].Init.y 	= Scene[number2].Init.y;
    Clays[1].Init.z 	= Scene[number2].Init.z;
    Clays[1].Rotation.x = Scene[number2].Rot.x;
    Clays[1].Rotation.y = Scene[number2].Rot.y;
    Clays[1].Rotation.z = Scene[number2].Rot.z;
    Clays[1].Scale.x 	= Scene[number2].Scale.x;
    Clays[1].Scale.y 	= Scene[number2].Scale.y;
    Clays[1].Scale.z 	= Scene[number2].Scale.z;
 	Clays[1].Speed		= Scene[number2].Speed;
 	Clays[1].Delay		= Scene[number2].Delay;
 	Clays[1].AngleY		= Scene[number2].AngleY;
 	Clays[1].AngleZ		= Scene[number2].AngleZ;
 	Clays[1].Rabbit		= Scene[number2].Rabbit;
 	Clays[1].Remove		= Scene[number2].Remove;
 	Clays[1].Water		= Scene[number2].Water;
	Clays[1].Velx		= Scene[number2].Speed * rsin(ConvertToPlayStation(Scene[number2].AngleY)) / ONE;
	Clays[1].Vely		= Scene[number2].Speed * rsin(ConvertToPlayStation(Scene[number2].AngleZ)) / ONE;
	Clays[1].Velz		= Scene[number2].Speed * rcos(ConvertToPlayStation(Scene[number2].AngleZ)) / ONE;
 	Clays[1].Hit		= FALSE;

    switch (Scene[number2].Color)
    {
    	case CC_WHITE:
    		address		= (u_long *)TMDADDRESS1;
    		address2	= (u_long *)TMDADDRESS4;
    		address3	= (u_long *)TMDADDRESS7;

    		break;

    	case CC_GREY:
    		address		= (u_long *)TMDADDRESS2;
    		address2	= (u_long *)TMDADDRESS5;
    		address3	= (u_long *)TMDADDRESS8;

    		break;

    	case CC_ORANGE:
    		address		= (u_long *)TMDADDRESS3;
    		address2	= (u_long *)TMDADDRESS6;
    		address3	= (u_long *)TMDADDRESS9;

    		break;
	}

    AddObject(address, &Clays[1].ObjectID, &Clays[1].Position, &Clays[1].Rotation, &Clays[1].Scale);
    AddAnimation(address2, Clays[1].ObjectID, 1);
    AddAnimation(address3, Clays[1].ObjectID, 2);

    if (Clays[1].Delay <= 0)
    {
    	Clays[1].Flying = TRUE;
    }

    WaitForStart(TRUE);

	volleft		= - (Clays[0].Position.x + 127);
	volright	= 127 - Clays[0].Position.x;

	if (volleft > 127)
	{
		volleft = 127;
	}

	else if (volleft < 64)
	{
		volleft = 64;
	}

	if (volright > 127)
	{
		volright = 127;
	}

	else if (volright < 64)
	{
		volright = 64;
	}

	PlaySound(LAUNCH_SND, LAUNCH_NOTE, volleft, volright);
}

DWORD AnimateClay(short clay)
{
	long 	x;
	long 	y;
	long 	z;
    short   volleft;
    short   volright;

	if (TRUE == Clays[clay].Flying)
	{
		if (TRUE == Clays[clay].Rabbit)
		{
			Flight[clay]			+= (float).35;
			Flight2[clay]			+= (float).35;

			Clays[clay].Position.x 		= Clays[clay].Init.x + (Clays[clay].Velx * Flight[clay])
				/ 50.0f;
			Clays[clay].Position.z 		= Clays[clay].Init.z;

			if (FALSE == Clays[clay].Hit)
			{
				Clays[clay].Position.y = Clays[clay].Init.y - (Clays[clay].Vely * Flight2[clay] *
					RABBITMULTIPLY - 1.5 * 32.2 * Flight2[clay] * Flight2[clay]) / 50.0f;
			}

			if (Clays[clay].Position.y >= Clays[clay].Init.y)
			{
				Flight2[clay] = 0.0f;

				if (FALSE == Clays[clay].Hit)
				{
					Clays[clay].Speed 	*= .70f;
					Clays[clay].Vely	= Clays[clay].Speed *
						rsin(ConvertToPlayStation(Clays[clay].AngleZ)) / ONE;
				}
			}
		}

		else
		{
			Flight[clay] += .35;

			Clays[clay].Position.x = Clays[clay].Init.x + (Clays[clay].Velx * Flight[clay] / 50.0f);
			Clays[clay].Position.y = Clays[clay].Init.y - (Clays[clay].Vely * Flight[clay] - .50 *
				32.2 * Flight[clay] * Flight[clay]) / 100.0f;
			Clays[clay].Position.z = Clays[clay].Init.z + (Clays[clay].Velz * Flight[clay] / 50.0f);
		}

		MoveObject(Clays[clay].ObjectID, &Clays[clay].Position);

		if (TRUE == Clays[clay].Rabbit && TRUE == Clays[clay].Flying)
		{
			if (Clays[clay].Init.x < 0)
			{
				if (Clays[clay].Position.x >= 0 && TRUE == CheckScreen(Clays[clay].ObjectID))
				{
					Clays[clay].Flying = FALSE;

        			if (TRUE == Clays[clay].Remove)
					{
						RemoveObject(Clays[clay].ObjectID);
					}
				}
			}

			else
			{
				if (Clays[clay].Position.x <= 0 && TRUE == CheckScreen(Clays[clay].ObjectID))
				{
					Clays[clay].Flying = FALSE;

        			if (TRUE == Clays[clay].Remove)
					{
						RemoveObject(Clays[clay].ObjectID);
					}
				}
			}
		}

		else if (Clays[clay].Position.z > ZOffscreen && TRUE == CheckScreen(Clays[clay].ObjectID))
		{
			Clays[clay].Flying = FALSE;

        	if (TRUE == Clays[clay].Remove)
			{
				RemoveObject(Clays[clay].ObjectID);
			}
		}

		else if (Clays[clay].Position.z > ZLimit && TRUE ==
			CheckFloor(Clays[clay].ObjectID, Floor))
		{
			Clays[clay].Flying = FALSE;

			if (TRUE == Clays[clay].Remove)
			{
				RemoveObject(Clays[clay].ObjectID);
			}

			if (TRUE == Clays[clay].Water && FALSE == Clays[clay].Hit)
			{
				PlaySound(SPLASH_SND, SPLASH_NOTE, 127, 127);
			}
		}
	}

	else if (Clays[clay].Delay > 0)
	{
		Clays[clay].Delay--;

		if (0 == Clays[clay].Delay)
		{
			Clays[clay].Flying = TRUE;

			volleft		= - (Clays[clay].Position.x + 127);
			volright	= 127 - Clays[clay].Position.x;

			if (volleft > 127)
			{
				volleft = 127;
			}

			else if (volleft < 64)
			{
				volleft = 64;
			}

			if (volright > 127)
			{
				volright = 127;
			}

			else if (volright < 64)
			{
				volright = 64;
			}

			PlaySound(LAUNCH_SND, LAUNCH_NOTE, volleft, volright);
		}
	}

	return ERR_NOERROR;
}

DWORD ReadModel(char *model, u_long *address, BOOL loadtexture)
{
	char filename[FILENAMELEN];

    strcpy(filename, DIRECTORY);
	strcat(filename, model);
	strcat(filename, ".tmd");

    if (NULL == model || NULL == address)
    {
#ifdef DEBUG
		printf("Bad Parameters to ReadModel\n");
#endif

    	return ERR_BADPARAMS;
    }

	if (ERR_FILEERROR == FileRead(filename, address))
	{
        return ERR_FILEERROR;
    }

	if (TRUE == loadtexture)
	{
		if (AddTIM(model) != ERR_NOERROR)
		{
			return ERR_FILEERROR;
		}
    }

	return ERR_NOERROR;
}

DWORD AddTIM(char *name)
{
	char filename[FILENAMELEN];

	strcpy(filename, DIRECTORY);
	strcat(filename, name);
	strcat(filename, ".tim");

	if (ERR_FILEERROR == FileRead(filename, TIMADDRESS))
	{
		return ERR_FILEERROR;
	}

	LoadTIM(TIMADDRESS);

	return ERR_NOERROR;
}

BOOL CheckHit(short clay)
{
	BOOL 	RetVal = FALSE;
	short	distance;
	short	xdir;
	short	ydir;
    short	sound;

	if (TRUE == Clays[clay].Flying && FALSE == Clays[clay].Hit && TRUE ==
		CheckIntersection(Clays[clay].ObjectID, Input.X, Input.Y, RANGE, &distance, &xdir, &ydir))
	{
		RetVal			= TRUE;
		Clays[clay].Hit	= TRUE;

		ClaysHit[Player]++;

		if (TRUE == Clays[clay].Rabbit)
		{
			Clays[clay].Flying 	= FALSE;

			Clays[clay].Rotation.x = 10;
			RotateObject(Clays[clay].ObjectID, &Clays[clay].Rotation);

			Clays[clay].Position.y = Clays[clay].Init.y;
			MoveObject(Clays[clay].ObjectID, &Clays[clay].Position);

			SetObjectFrame(Clays[clay].ObjectID, 1);

			if (TRUE == Clays[clay].Remove)
			{
				RemoveObject(Clays[clay].ObjectID);
			}
		}

		else if (distance < INNERRANGE)
		{
			SetObjectFrame(Clays[clay].ObjectID, 1);
		}

		else
		{
			if (xdir < 0)
			{
				if (ydir < 0)
				{
					Clays[clay].Rotation.y	= 180;
				}

				else
				{
					Clays[clay].Rotation.y	= 270;
				}
			}

			else
			{
				if (ydir < 0)
				{
					Clays[clay].Rotation.y	= 90;
				}
			}

			SetObjectFrame(Clays[clay].ObjectID, 2);
			RotateObject(Clays[clay].ObjectID, &Clays[clay].Rotation);
		}

		sound = rand() % MAXSOUNDS;

		PlaySound(HIT_SND + sound, VOICE_NOTE, 127, 127);
	}

	return RetVal;
}

DWORD PrintScores()
{
	char 	string[20];
	WORD    Player = 0;

	DrawTextString("SCORE BOARD;", 4, 1);
	DrawTextString("\\\\\\\\\\\\\\\\\\\\\\\\", 4, 2);

	ClaysTotal[Player] += ClaysHit[Player];

	sprintf(string, "PLAYER %d;  %2d %3d", Player + 1, ClaysHit[Player], ClaysTotal[Player]);

	DrawTextString(string, 1, 4);
	DrawTextString("SHOOT TO CONTINUE.", 1, 12);

	while (1)
	{
    	Flip();

        ReadInput(&Input, 0);

		if (Input.Type != CON_NONE)
		{
			if ((BUT_TRIGGER & Input.Buttons) != 0)
			{
				PlaySound(GUN_SND, GUN_NOTE, 127, 127);

				break;
			}
		}
	}

	ClearText();

    Input.X		= SCREENWIDTH / 2;
    Input.Y		= SCREENHEIGHT / 2;

	SetInputMousePosition(Input.X, Input.Y);
	SetMousePosition(Input.X - MOUSESIZE / 2, Input.Y - MOUSESIZE / 2);

	return ERR_NOERROR;
}

DWORD WaitForStart(BOOL PullSound)
{
	DrawTextString("PRESS START.", 4, 12);

	while (1)
	{
    	Flip();

        ReadInput(&Input, 0);

		if (Input.Type != CON_NONE)
		{
            if ((BUT_START & Input.Buttons) != 0)
			{
                if (TRUE == PullSound)
                {
                    PlaySound(PULL_SND, PULL_NOTE, 127, 127);
                }

				break;
			}
		}
	}

	ClearText();

    Input.X		= SCREENWIDTH / 2;
    Input.Y		= SCREENHEIGHT / 2;

	SetInputMousePosition(Input.X, Input.Y);
	SetMousePosition(Input.X - MOUSESIZE / 2, Input.Y - MOUSESIZE / 2);

	return ERR_NOERROR;
}


