// **************************************************************************
// *				 Sporting Clays for the Playstation						*
// *					   (C) 1999 Charles Doty                           	*
// *	 	  Display Header file contains screen related code				*
// **************************************************************************

#ifndef __DISPLAY_H
#define __DISPLAY_H

#include "defines.h"

#include <libapi.h>
#include <libetc.h>
#include <libgte.h>
#include <libgpu.h>
#include <libgs.h>

#define MAXCELLS	48
#define CHAR_COL	(128 / TILESIZE)
#define CHAR_ROW	(48 / CHAR_COL)
#define CHAR_FILE   "FONT.TIM"

DWORD DisplayInitialize();
  // Initializes the display

DWORD Flip();
  // Flips the display buffers

DWORD LoadPicture(u_long *picture);
  // Loads a TIM a creates 2 display sprites from it

DWORD LoadMouse(u_long *picture);
  // Loads a TIM and creates a mouse sprites from it

DWORD LoadShot(u_long *picture, long shot);
  // Loads a TIM and creates a shot sprites from it

DWORD SetMousePosition(long x, long y);
  // Sets the position of the mouse

DWORD SetShotPosition(long x, long y, long shot);
  // Sets the position of the shot

BOOL IsNTSC();
  // Returns TRUE if the display is NTSC, and FALSE for PAL.

DWORD InitializeTextDisplay();
  // Initialize GsBG, GsMap, and GsCell structures.

DWORD ClearText();
  // Clears all text off the screen

DWORD DrawTextString(char *string, long x, long y);
  // Draws text to the screen. X and Y are tile positions.

#endif

