// **************************************************************************
// *				 Sporting Clays for the Playstation						*
// *					   (C) 1999 Charles Doty                           	*
// *	 	   Display Source file contains screen related code				*
// **************************************************************************

#include "display.h"
#include "scene3d.h"

GsOT        OT[2];                              // Ordering table
GsOT_TAG    OT_TAG[2][1 << OT_LENGTH];          // Ordering table unit
PACKET      GPUPacketArea[2][PACKETMAX * 24];   // GPU Packet Area
GsSPRITE    Sprite1;                            // Background 1 sprite structure
GsSPRITE    Sprite2;                            // Background 2 sprite structure
GsSPRITE    Mouse;                            	// Mouse sprite structure
GsSPRITE    Shots[MAXSHOTS];                   	// Mouse sprite structure
GsRVIEW2    View;								// Viewpoint
GsBG		Background;								// Used for displaying text on the screen
GsMAP		Map;								// Used for displaying text on the screen
GsCELL		Cells[MAXCELLS];					// Number of cells used to display text
BOOL		Is_NTSC;							// is the display in NTSC mode?
BOOL		MouseLoaded;						// Has the mouse image been loaded?
BOOL		ShotsLoaded[MAXSHOTS];				// Has the shot image been loaded?
WORD		IndexArray[(SCREENHEIGHT / TILESIZE) * (SCREENWIDTH / TILESIZE)];
u_long   	BgWorkArea[(((SCREENWIDTH / 8 + 1) * (SCREENHEIGHT / TILESIZE + 1 + 1) * 6 * 4) * 2 + 2)];

extern BOOL MouseUsed;
extern BOOL PadUsed;
extern BOOL Shot[2];							// Draw shot (miss) 1/2

DWORD DisplayInitialize()
{
	long	loop;

	ResetCallback();
    InitGeom();

    // Check BIOS to see which mode to use.
    if ('E' == *(char *)0xBFC7FF52)
    {
        SetVideoMode(MODE_PAL);

		Is_NTSC = FALSE;
    }

    else
    {
        SetVideoMode(MODE_NTSC);

		Is_NTSC = TRUE;
    }

	GsInitGraph(SCREENWIDTH, SCREENHEIGHT, GsNONINTER | GsOFSGPU, 0, 0);
    GsDefDispBuff(0, 0, 0, SCREENHEIGHT);

    OT[0].length    = OT_LENGTH;
    OT[0].org       = OT_TAG[0];
    OT[1].length    = OT_LENGTH;
    OT[1].org       = OT_TAG[1];

    GsSetLightMode(0);
	Scene3DInitialize();

	MouseLoaded = FALSE;

	for (loop = 0; loop < MAXSHOTS; loop++)
	{
		ShotsLoaded[loop] = FALSE;
	}

	InitializeTextDisplay();

	return ERR_NOERROR;
}

DWORD Flip()
{
    long 	ActiveBuffer;
    long	loop;

    ActiveBuffer = GsGetActiveBuff();
    GsSetWorkBase((PACKET *)GPUPacketArea[ActiveBuffer]);
    GsClearOt(0, 0, &OT[ActiveBuffer]);

    // Adds Sprite1 to the list
    GsSortFastSprite(&Sprite1, &OT[ActiveBuffer], OT_LENGTH);

    // Adds Sprite2 to the list
    GsSortFastSprite(&Sprite2, &OT[ActiveBuffer], OT_LENGTH);

	for (loop = 0; loop < MAXSHOTS; loop++)
	{
    	if (TRUE == Shot[loop])
    	{
    		// Adds Shots to the list
    		GsSortFastSprite(&Shots[loop], &OT[ActiveBuffer], OT_LENGTH - 1);
    	}
	}

    if (TRUE == MouseUsed || TRUE == PadUsed)
    {
    	// Adds Mouse to the list
    	GsSortFastSprite(&Mouse, &OT[ActiveBuffer], 0);
    }

	GsSortFixBg16(&Background, BgWorkArea, &OT[ActiveBuffer], 0);

    Render(ActiveBuffer);

    DrawSync(0);

    VSync(0);

    GsSwapDispBuff();

    GsSortClear(0, 0, 0, &OT[ActiveBuffer]);
    GsDrawOt(&OT[ActiveBuffer]);

	return ERR_NOERROR;
}

DWORD LoadPicture(u_long *picture)
{
    long    TIMFormat;
    RECT   	Rect;
	GsIMAGE	Image;

	if (NULL == picture)
	{
#ifdef DEBUG
		printf("Bad Parameters to LoadPicture.\n");
#endif

		return ERR_BADPARAMS;
	}

    // Returns information about the TIM
    GsGetTimInfo(picture + 1, &Image);

    // Checks the bit depth of the TIM
    TIMFormat = Image.pmode & 0x03;

    // Set up area of the TIM to use
    Rect.x  = Image.px;
    Rect.y  = Image.py;
    Rect.w  = Image.pw;
    Rect.h  = Image.ph;

    // Loads TIM into memory
    LoadImage(&Rect, Image.pixel);

    // Sets up Sprite1
    Sprite1.attribute 	= (1 << 27) | (TIMFormat << 24);
    Sprite1.x       	= 0;
    Sprite1.y       	= 0;
    Sprite1.w       	= Image.pw > 255 ? 256 : Image.pw;
    Sprite1.h       	= Image.ph;
    Sprite1.tpage   	= GetTPage(TIMFormat, 0, Image.px, Image.py);

    Sprite1.u      		= 0;
    Sprite1.v 			= 0;
    Sprite1.r       	= 128;
    Sprite1.b       	= 128;
    Sprite1.g       	= 128;
    Sprite1.scalex  	= ONE;
    Sprite1.scaley  	= ONE;
    Sprite1.rotate  	= 0 * ONE;

    Sprite2.attribute 	= (1 << 27) | (TIMFormat << 24);
    Sprite2.x       	= Sprite1.x + 256;
    Sprite2.y       	= Sprite1.y;
    Sprite2.w       	= Image.pw - 256;
    Sprite2.h       	= Image.ph;
    Sprite2.tpage   	= GetTPage(TIMFormat, 0, Image.px + 256, Image.py);

    Sprite2.u       	= 0;
    Sprite2.v       	= 0;
    Sprite2.r       	= 128;
    Sprite2.b       	= 128;
    Sprite2.g       	= 128;
    Sprite2.scalex  	= ONE;
    Sprite2.scaley  	= ONE;
    Sprite2.rotate  	= 0 * ONE;

	return ERR_NOERROR;
}

DWORD LoadMouse(u_long *picture)
{
    long    TIMFormat;
    RECT   	Rect;
	GsIMAGE	Image;

	if (NULL == picture)
	{
#ifdef DEBUG
		printf("Bad Parameters to LoadMouse.\n");
#endif

		return ERR_BADPARAMS;
	}

    // Returns information about the TIM
    GsGetTimInfo(picture + 1, &Image);

    // Checks the bit depth of the TIM
    TIMFormat = Image.pmode & 0x03;

    // Set up area of the TIM to use
    Rect.x  = Image.px;
    Rect.y  = Image.py;
    Rect.w  = Image.pw;
    Rect.h  = Image.ph;

    // Loads TIM into memory
    LoadImage(&Rect, Image.pixel);

    // Sets up Sprite1
    Mouse.attribute 	= (1 << 27) | (TIMFormat << 24);
    Mouse.x       		= 0;
    Mouse.y       		= 0;

	if (0 == TIMFormat)
	{
    	Mouse.w       	= Image.pw * 4;
    }

	else if (1 == TIMFormat)
	{
    	Mouse.w       	= Image.pw * 2;
    }

	else if (2 == TIMFormat)
	{
    	Mouse.w       	= Image.pw;
    }

    Mouse.h       		= Image.ph;
    Mouse.tpage   		= GetTPage(TIMFormat, 0, Image.px, Image.py);
    Mouse.u      		= 0;
    Mouse.v 			= 0;
    Mouse.r       		= 128;
    Mouse.b       		= 128;
    Mouse.g       		= 128;
    Mouse.scalex  		= ONE;
    Mouse.scaley  		= ONE;
    Mouse.rotate  		= 0 * ONE;

	if (TIMFormat < 2)
	{
		Rect.x		= Image.cx;
		Rect.y		= Image.cy;
		Rect.w		= Image.cw;
		Rect.h		= Image.ch;

		LoadImage(&Rect, Image.clut);

		Mouse.cx	= Image.cx;
		Mouse.cy	= Image.cy;
	}

	MouseLoaded = TRUE;

	return ERR_NOERROR;
}

DWORD LoadShot(u_long *picture, long shot)
{
    long    TIMFormat;
    RECT   	Rect;
	GsIMAGE	Image;

	if (NULL == picture)
	{
#ifdef DEBUG
		printf("Bad Parameters to LoadMouse.\n");
#endif

		return ERR_BADPARAMS;
	}

    // Returns information about the TIM
    GsGetTimInfo(picture + 1, &Image);

    // Checks the bit depth of the TIM
    TIMFormat = Image.pmode & 0x03;

    // Set up area of the TIM to use
    Rect.x  = Image.px;
    Rect.y  = Image.py;
    Rect.w  = Image.pw;
    Rect.h  = Image.ph;

    // Loads TIM into memory
    LoadImage(&Rect, Image.pixel);

    // Sets up Shot
    Shots[shot].attribute 	= (1 << 27) | (TIMFormat << 24);
    Shots[shot].x       	= 0;
    Shots[shot].y       	= 0;

	if (0 == TIMFormat)
	{
    	Shots[shot].w      	= Image.pw * 4;
    }

	else if (1 == TIMFormat)
	{
    	Shots[shot].w      	= Image.pw * 2;
    }

	else if (2 == TIMFormat)
	{
    	Shots[shot].w      	= Image.pw;
    }

    Shots[shot].h       	= Image.ph;
    Shots[shot].tpage   	= GetTPage(TIMFormat, 0, Image.px, Image.py);
    Shots[shot].u      		= 0;
    Shots[shot].v 			= 0;
    Shots[shot].r       	= 128;
    Shots[shot].b       	= 128;
    Shots[shot].g       	= 128;
    Shots[shot].scalex  	= ONE;
    Shots[shot].scaley  	= ONE;
    Shots[shot].rotate  	= 0 * ONE;

	if (TIMFormat < 2)
	{
		Rect.x				= Image.cx;
		Rect.y				= Image.cy;
		Rect.w				= Image.cw;
		Rect.h				= Image.ch;

		LoadImage(&Rect, Image.clut);

		Shots[shot].cx		= Image.cx;
		Shots[shot].cy		= Image.cy;
	}

	ShotsLoaded[shot] 		= TRUE;

	return ERR_NOERROR;
}

DWORD SetMousePosition(long x, long y)
{
	if (FALSE == MouseLoaded)
	{
#ifdef DEBUG
		printf("Mouse Image has not been loaded prior to calling SetMousePosition.\n");
#endif

		return ERR_INITERROR;
	}

	Mouse.x = x;
	Mouse.y = y;

	return ERR_NOERROR;
}

DWORD SetShotPosition(long x, long y, long shot)
{
	if (FALSE == ShotsLoaded[shot])
	{
#ifdef DEBUG
		printf("Shot Image has not been loaded prior to calling SetShotPosition.\n");
#endif

		return ERR_INITERROR;
	}

	Shots[shot].x 	= x;
	Shots[shot].y	= y;

	return ERR_NOERROR;
}

BOOL IsNTSC()
{
	return Is_NTSC;
}

DWORD InitializeTextDisplay()
{
    long    TIMFormat;
	char	filename[FILENAMELEN];
	short 	outerloop;
	short 	innerloop;
	GsIMAGE Image;
	RECT	Rect;
    u_long	*address	= (u_long *)TIMADDRESS;
	short	TPage;

	strcpy(filename, DIRECTORY);
	strcat(filename, CHAR_FILE);

	if (ERR_FILEERROR == FileRead(filename, address))
	{
		return ERR_FILEERROR;
	}

    // Returns information about the TIM
    GsGetTimInfo(address + 1, &Image);

    // Checks the bit depth of the TIM
    TIMFormat = Image.pmode & 0x03;

    // Set up area of the TIM to use
    Rect.x  = Image.px;
    Rect.y  = Image.py;
    Rect.w  = Image.pw;
    Rect.h  = Image.ph;

    // Loads TIM into memory
    LoadImage(&Rect, Image.pixel);

	TPage = GetTPage(TIMFormat, 0, Image.px, Image.py);

	if (TIMFormat < 2)
	{
		Rect.x				= Image.cx;
		Rect.y				= Image.cy;
		Rect.w				= Image.cw;
		Rect.h				= Image.ch;

		LoadImage(&Rect, Image.clut);
	}

	memset(IndexArray, 0xFF, sizeof(IndexArray));

	for (outerloop = 0; outerloop < CHAR_ROW; outerloop++)
	{
		for (innerloop = 0; innerloop < CHAR_COL; innerloop++)
		{
			Cells[outerloop * CHAR_COL + innerloop].u 		= innerloop * TILESIZE;
 			Cells[outerloop * CHAR_COL + innerloop].v	  	= outerloop * TILESIZE + 32;
		    Cells[outerloop * CHAR_COL + innerloop].tpage 	= TPage;
			Cells[outerloop * CHAR_COL + innerloop].flag	= 0;
			Cells[outerloop * CHAR_COL + innerloop].cba 	= (Image.cx >> 4) |	(Image.cy << 6);
		}
	}

	Map.cellh 				= TILESIZE;
	Map.cellw 				= TILESIZE;
	Map.ncellh 				= SCREENHEIGHT / TILESIZE;
	Map.ncellw 				= SCREENWIDTH / TILESIZE;
	Map.base				= Cells;
	Map.index				= (WORD *)IndexArray;

	Background.attribute	= (1 << 27) | (TIMFormat << 24);
	Background.x			= 0;
	Background.y			= 0;
	Background.w			= 320;
	Background.h			= 240;
	Background.r			= 128;
	Background.g			= 128;
	Background.b			= 128;
	Background.scrollx		= 0;
	Background.scrolly		= 0;
	Background.map			= &Map;
	Background.mx			= 0;
	Background.my			= 0;
	Background.scalex		= ONE;
	Background.scaley		= ONE;
	Background.rotate		= 0;

	GsInitFixBg16(&Background, BgWorkArea);		// set up background

	return ERR_NOERROR;
}

DWORD ClearText()
{
	memset(IndexArray, 0xFF, sizeof(IndexArray));

	return ERR_NOERROR;
}

DWORD DrawTextString(char *string, long x, long y)
{
	WORD 	*start;
	WORD	length;
	WORD 	loop;
	char	value;

	if (NULL == string || y < 0 || y >= SCREENHEIGHT / TILESIZE || x < 0 ||
		x >= SCREENWIDTH / TILESIZE)
	{
		return ERR_BADPARAMS;
	}

	start 	= IndexArray + y * SCREENWIDTH / TILESIZE + x;
	length 	= strlen(string);

	if (length + x > SCREENWIDTH / TILESIZE)
	{
		length = SCREENWIDTH / TILESIZE - x;
	}

	for (loop = 0; loop < length; loop++)
	{
		value = string[loop];

		if (value < 48)
		{
			*start = 0xffff;
		}

		else
		{
			*start = value - 48;
		}

		start++;
	}

	return ERR_NOERROR;
}
