// **************************************************************************
// *				 Sporting Clays for the Playstation						*
// *					   (C) 1999 Charles Doty                           	*
// *	 	  Display Header file contains screen related code				*
// **************************************************************************

#ifndef __DEFINES_H
#define	__DEFINES_H

//#define DEBUG
// Adds debug messages

#define COMPUTER
// Reads files through caetla

#include <sys/types.h>

#define BYTE				unsigned char
#define WORD				unsigned short
#define DWORD				unsigned long

#define BOOL				long
#define TRUE				1
#define FALSE 				0

// Screen defines
#define SCREENWIDTH     	320
#define SCREENHEIGHT    	240
#define TILESIZE    		16

// Playstation defines
#define OT_LENGTH       	10
#define PACKETMAX       	1000			// Maximum number of packets per frame

// Error defines
#define	ERR_NOERROR			0x00000000		// No error
#define ERR_BADPARAMS		0x00000001      // Parameters to a function are incorrect
#define ERR_NONEAVAILABLE   0x00000002		// No objects available
#define ERR_FILEERROR		0x00000003		// Unable to open file
#define ERR_INITERROR		0x00000004		// Error while initializing
#define ERR_PLAYERROR		0x00000005		// Unable to play sound

// Object defines
#define MAXOBJECTS			2               // Maximum 3D Objects
#define MAXFRAMES			3				// Maximum frames of animation per 3d object
#define MAXSHOTS			2				// Maximum number of shots allowed
#define SHOTSIZE			16				// Size of Shot Image
#define MAXPLAYERS			4				// Maximum players in a game

// Filename defines
#define FILENAMELEN			80

// Controller flags
#define	DIR_CENTER			0x00000000		// Center
#define	DIR_UP				0x00000001		// Up
#define	DIR_DOWN			0x00000002		// Down
#define	DIR_LEFT			0x00000004		// Left
#define	DIR_RIGHT			0x00000008		// Right

// Button flags
#define	BUT_NONE			0x00000000		// No buttons pressed
#define	BUT_START			0x00000001		// Start pressed
#define BUT_LEFT			0x00000002		// Mouse left button pressed
#define BUT_TRIGGER			0x00000002		// Trigger pressed
#define BUT_RIGHT			0x00000004		// Mouse right button pressed

// Controller Types
#define CON_NONE			0x00000000		// None
#define CON_GUN				0x00000001		// Gun controller
#define CON_MOUSE			0x00000002		// Mouse controller
#define CON_PAD				0x00000003		// Standard pad controller

// Input defines
#define	NUMCONTROLLERS	2					// Number of controllers supported

#ifdef COMPUTER
#define DIRECTORY           "pcdrv:data//"  // Location of files
#else
#define DIRECTORY           "\\DATA\\"  // Location of files
#endif

// Memory defines
#define TIMADDRESS     		0x80100000		// Location of TIM
#define TMDADDRESS1    		0x80130000		// Location of TMD1
#define TMDADDRESS2    		0x80132000		// Location of TMD2
#define TMDADDRESS3    		0x80134000		// Location of TMD3
#define TMDADDRESS4    		0x80136000		// Location of TMD1
#define TMDADDRESS5    		0x80138000		// Location of TMD2
#define TMDADDRESS6    		0x8013a000		// Location of TMD3
#define TMDADDRESS7    		0x8013c000		// Location of TMD1
#define TMDADDRESS8    		0x8013e000		// Location of TMD2
#define TMDADDRESS9    		0x80140000		// Location of TMD3
#define VHADDRESS    		0x80142000		// Location of VH file
#define VBADDRESS    		0x80144000		// Location of VB file
#define SCENEADDRESS    	0x80148000		// Location of Scene file
#define NEXTADDRESS    		0x8014a000		// Next address

struct POS
{
	short	x;								// X position
	short	y;								// Y position
	short	z;								// Z position
};

struct ROT
{
	short	x;								// X rotation
	short	y;								// Y rotation
	short	z;								// Z rotation
};

struct SCALE
{
	short	x;								// X scale
	short	y;								// Y scale
	short	z;								// Z scale
};

#define PI 					3.14285714

#endif

