// **************************************************************************
// *				Sporting Clays for the Nintendo 64						*
// *					   (C) 1999 Charles Doty                           	*
// *	 Sound Source file contains sound playing and loading code			*
// **************************************************************************

#include <ultra64.h>

#include "sound.h"

#define GUN_SIZE    24216
#define LAUNCH_SIZE 4976
#define EMPTY_SIZE 	2032
#define MISS_SIZE 	61784
#define HIT_SIZE 	47728
#define PULL_SIZE	9928
#define SPLASH_SIZE	41696

extern BYTE Empty[EMPTY_SIZE];
extern BYTE Gun[GUN_SIZE];
extern BYTE Hit[MAXSOUNDS][HIT_SIZE];
extern BYTE Launch[LAUNCH_SIZE];
extern BYTE Miss[MAXSOUNDS][MISS_SIZE];
extern BYTE Pull[PULL_SIZE];
extern BYTE Splash[SPLASH_SIZE];

DWORD SoundInitialize()
{
	return ERR_NOERROR;
}

DWORD PlaySound(long sound)
{
	long soundnum;

	switch (sound)
	{
		case GUN_SND:
			osAiSetFrequency(11025);
			osAiSetNextBuffer(Gun, GUN_SIZE);

			break;

		case LAUNCH_SND:
//			osAiSetFrequency(11025);
//			osAiSetNextBuffer(Launch, LAUNCH_SIZE);

			break;

		case EMPTY_SND:
			osAiSetFrequency(8000);
			osAiSetNextBuffer(Empty, EMPTY_SIZE);

			break;

		case MISS_SND:
	        soundnum = rand() % MAXSOUNDS;

			osAiSetFrequency(11025);
//			osAiSetNextBuffer(Miss[soundnum], MISS_SIZE);

			break;

		case HIT_SND:
	        soundnum = rand() % MAXSOUNDS;

			osAiSetFrequency(11025);
//			osAiSetNextBuffer(Hit[soundnum], HIT_SIZE);

			break;

		case PULL_SND:
			osAiSetFrequency(5800);
			osAiSetNextBuffer(Pull, PULL_SIZE);

			break;

		case SPLASH_SND:
			osAiSetFrequency(8000);
			osAiSetNextBuffer(Splash, SPLASH_SIZE);

			break;
	}

	return ERR_NOERROR;
}
