// **************************************************************************
// *				Sporting Clays for the Nintendo 64						*
// *					   (C) 1999 Charles Doty                          	*
// *	 	   3D Header Source file contains 3D related code				*
// **************************************************************************

#ifndef __SCENE3D_H
#define __SCENE3D_H

#include "defines.h"
#include "math.h"

#define MAXPOLYGONS 200                     // maximum amount of polygons
#define ZBUFFERSIZE 1024                    // depth of Z Buffer (OT)

typedef struct
{
    vector			Position;               // Position
    vector         	Rotation;               // Rotation
    vector			Scale;                  // Position
	BOOL			Used;					// Is object in use?
	long			CurrentFrame;			// Current Frame
	DWORD			Color;					// Color of the clay
} Object3D;

DWORD Scene3DInitialize();
  // Initializes the 3D Scene

DWORD AddObject(long color, DWORD *ObjectID, POS *position, ROT *rotation, SCALE *scale);
  // Adds object to scene

DWORD MoveObject(DWORD ObjectID, POS *position);
  // Changes the position of a 3D Object

DWORD RotateObject(DWORD ObjectID, ROT *rotation);
  // Changes the rotation of a 3D Object

DWORD SetObjectFrame(DWORD ObjectID, long frame);
  // Sets objects current frame

BOOL CheckIntersection(DWORD ObjectID, long x, long y, long range, long *distance, long *xdir,
	long *ydir);
  // Checks object intersection with a point

BOOL CheckFloor(DWORD ObjectID, long y);
  // Checks object intersection with scene defined floor

BOOL CheckScreen(DWORD ObjectID);
  // Checks if object has left the screen

DWORD Render(Gfx **GfxList);
  // Renders the 3D Objects

#endif
