// **************************************************************************
// *				Sporting Clays for the Nintendo 64						*
// *					   (C) 1999 Charles Doty                           	*
// *	 		   Input Source file contains input code					*
// **************************************************************************

#ifndef __INPUT_H
#define __INPUT_H

#include "defines.h"

typedef struct
{
	DWORD			Type;		// Type of controller
	DWORD			Buttons;	// Button flags
	DWORD			Controller;	// Direction flags for the controller
	long			X;			// Relative x position of the controller
	long			Y;			// Relative y position of the controller
} InputStruct;

DWORD InputInitialize();
  // Initialize input system.

DWORD ReadInput(InputStruct *Input, DWORD gun);
  // Reads input

DWORD SetPadMoveValues(DWORD x, DWORD y);
  // Sets pad movement resolution

DWORD ReadPad(InputStruct *Input, DWORD controller);
  // Read pad specific function

DWORD ReadAnalog(InputStruct *Input, DWORD controller);
  // Read analog specific function

DWORD SetMouseLimits(long x1, long y1, long x2, long y2);
  // Sets the area that the mouse can move in.

DWORD SetInputMousePosition(long x, long y);
  // Sets mouse position

DWORD Convert2SJIS(BYTE *string, BYTE *dest);
  // Converts string from ASCII to SJIS.

#endif
