// **************************************************************************
// *				Sporting Clays for the Nintendo 64						*
// *					   (C) 1999 Charles Doty                           	*
// *	 	  Display Header file contains screen related code				*
// **************************************************************************

#ifndef __DISPLAY_H
#define __DISPLAY_H

#include <ultra64.h>

#include "defines.h"

#define MAX_ENTITIES    6
#define GLIST_LEN       (2048 * 4)

typedef struct
{
	Mtx   	projection;
	Mtx   	modeling_translate[MAX_ENTITIES];
	Mtx   	modeling_rotate[MAX_ENTITIES][3];
	Gfx		glist[GLIST_LEN];
} dynamic_stuff;

DWORD DisplayInitialize();
  // Initializes the display

DWORD Flip();
  // Flips the display buffers

DWORD SelectPicture(long scene);
  // Loads a TIM a creates 2 display sprites from it

DWORD SetMousePosition(long x, long y);
  // Sets the position of the mouse

DWORD SetShotPosition(long x, long y, long shot);
  // Sets the position of the shot

BOOL IsNTSC();
  // Returns TRUE if the display is NTSC, and FALSE for PAL.

DWORD InitializeTextDisplay();
  // Initialize GsBG, GsMap, and GsCell structures.

DWORD ClearText();
  // Clears all text off the screen

DWORD DrawTextString(char *string, long x, long y);
  // Draws text to the screen. X and Y are tile positions.

#endif

