// **************************************************************************
// *				Sporting Clays for the Nintendo 64						*
// *					   (C) 1999 Charles Doty                           	*
// *	 	  Display Header file contains screen related code				*
// **************************************************************************

#ifndef __DEFINES_H
#define	__DEFINES_H

#define DEBUG
// Adds debug messages

#define BYTE				unsigned char
#define WORD				unsigned short
#define DWORD				unsigned long

#define BOOL				long
#define TRUE				1
#define FALSE 				0

// Screen defines
#define SCREENWIDTH     	320
#define SCREENHEIGHT    	240
#define FONTSIZE			16				// Size of each letter

// Playstation defines
#define OT_LENGTH       	10
#define PACKETMAX       	1000			// Maximum number of packets per frame

// Error defines
#define	ERR_NOERROR			0x00000000		// No error
#define ERR_BADPARAMS		0x00000001      // Parameters to a function are incorrect
#define ERR_NONEAVAILABLE   0x00000002		// No objects available
#define ERR_FILEERROR		0x00000003		// Unable to open file
#define ERR_INITERROR		0x00000004		// Error while initializing
#define ERR_PLAYERROR		0x00000005		// Unable to play sound

// Object defines
#define MAXOBJECTS			2               // Maximum 3D Objects
#define MAXFRAMES			3				// Maximum frames of animation per 3d object
#define MAXSHOTS			2				// Maximum number of shots allowed
#define SHOTSIZE			16				// Size of Shot Image
#define MOUSESIZE			16				// Size of Mouse Image
#define MAXPLAYERS			4				// Maximum players in a game

// Scene defines
#define MAXSCENES			3				// Maximum number of scenes
#define MAXSCENESIZE		432				// Maximum scene size (binary)
#define MAXCOURSES			1				// Maximum courses
#define RANGE               10              // Range to check for shot
#define INNERRANGE          2               // Inner range to check for breaking

// Sound Defines
#define GUN_SND		1
#define LAUNCH_SND	2
#define EMPTY_SND	3
#define MISS_SND	4
#define HIT_SND		5
#define PULL_SND	6
#define SPLASH_SND	7

#define MAXSOUNDS	3

// Controller flags
#define	DIR_CENTER			0x00000000		// Center
#define	DIR_UP				0x00000001		// Up
#define	DIR_DOWN			0x00000002		// Down
#define	DIR_LEFT			0x00000004		// Left
#define	DIR_RIGHT			0x00000008		// Right

// Button flags
#define	BUT_NONE			0x00000000		// No buttons pressed
#define	BUT_START			0x00000001		// Start pressed
#define BUT_LEFT			0x00000002		// Mouse left button pressed
#define BUT_TRIGGER			0x00000002		// Trigger pressed
#define BUT_RIGHT			0x00000004		// Mouse right button pressed

// Controller Types
#define CON_NONE			0x00000000		// None
#define CON_GUN				0x00000001		// Gun controller
#define CON_MOUSE			0x00000002		// Mouse controller
#define CON_PAD				0x00000003		// Standard pad controller

// Input defines
#define	NUMCONTROLLERS		4				// Number of controllers supported

// Memory defines
#define TIMADDRESS     		0x80100000		// Location of TIM
#define TMDADDRESS1    		0x80130000		// Location of TMD1
#define TMDADDRESS2    		0x80132000		// Location of TMD2
#define TMDADDRESS3    		0x80134000		// Location of TMD3
#define TMDADDRESS4    		0x80136000		// Location of TMD1
#define TMDADDRESS5    		0x80138000		// Location of TMD2
#define TMDADDRESS6    		0x8013a000		// Location of TMD3
#define TMDADDRESS7    		0x8013c000		// Location of TMD1
#define TMDADDRESS8    		0x8013e000		// Location of TMD2
#define TMDADDRESS9    		0x80140000		// Location of TMD3
#define VHADDRESS    		0x80142000		// Location of VH file
#define VBADDRESS    		0x80144000		// Location of VB file
#define SCENEADDRESS    	0x80148000		// Location of Scene file
#define NEXTADDRESS    		0x8014a000		// Next address

#define BACKGROUNDBLOCKS	48				// Number of block to construct background image

typedef struct
{
	long	x;								// X position
	long	y;								// Y position
	long	z;								// Z position
} POS;

typedef struct
{
	long	x;								// X rotation
	long	y;								// Y rotation
	long	z;								// Z rotation
} ROT;

typedef struct
{
	long	x;								// X scale
	long	y;								// Y scale
	long	z;								// Z scale
} SCALE;

#ifndef NORECT
typedef struct
{
	long	x;								// Top x
	long	y;								// Top y
	long	w;                              // Bottom x / width
	long	h;                              // Bottom y / height
} RECT;
#endif
#define PI 					3.14285714

#ifndef NOPRINTF
extern char __str[256];
extern void __PrintStr (char *str);

#define printf(x...) ({ sprintf(__str, x); __PrintStr(__str); })
#endif

#endif

