
void WritePI (unsigned long addr, unsigned long c)
   {

   // Align address to 4 byte boundary.
   // Unaligned addresses will cause a permanent loop.

   addr &=0xbffffffc;

   // Wait for parallel interface not busy
   do {} while (*(volatile unsigned long *) (0xa4600010) & 3);

   *(unsigned long *)(addr) = c;
   }


unsigned long ReadPI ( unsigned long addr )
   {

   // Align address to 4 byte boundary.
   // Unaligned addresses will cause a permanent loop.

   addr &=0xbffffffc;

   // Wait for parallel interface not busy
   do {} while (*(volatile unsigned long *) (0xa4600010) & 3);

   return *(unsigned long *)(addr);
   }


void WritePILastPage (int addr, unsigned long c)
   {

   // Align address to 4 byte boundary.
   // Unaligned addresses will cause a permanent loop.

   addr &=0xfffc;

   // Wait for parallel interface not busy
   do {} while (*(volatile unsigned long *) (0xa4600010) & 3);

   *(unsigned long *)(0xb1ffff00 + addr) = c;
   }

