//---------------------------------------------------------------------------
// Scene Header File
// Contains structures used to deal with scenes
//---------------------------------------------------------------------------

#ifndef __SCENE_H
#define __SCENE_H

#include "defines.h"

#define MAXRECTS		24
#define MAXCLAYS		6
#define VERSION			0x00010001

typedef struct
{
	long			Speed;	// Clay speed
	long			Color;	// Clay color
	long			Delay;	// Time before clay is launched
    ROT				Rot;    // Rotation of clay
    SCALE			Scale;  // Scale of clay
    POS				Init;   // Initial position of clay
	long			AngleY;	// Y angle of clay launch
	long			AngleZ;	// Z angle of clay launch
	BOOL			Rabbit;	// Is this a 'rabbit' setup
	BOOL			Remove;	// Remove Clay from screen when ground is hit?
	BOOL			Water;	// Should clay make a splash?
} SceneStruct;

// Clay Colors
#define CC_WHITE			0x00000000
#define CC_GREY				0x00000001
#define CC_ORANGE			0x00000002

#endif
