// **************************************************************************
// *				Sporting Clays for the Nintendo 64						*
// *					   (C) 1999 Charles Doty                           	*
// *	 	   	  Static Source file contains static data					*
// **************************************************************************

#include <ultra64.h>

#include "defines.h"
#include "textures\grey.h"
#include "textures\orange.h"
#include "textures\white.h"

extern WORD ZBuffer[SCREENWIDTH * SCREENHEIGHT];

static Vp ViewPort =
{
	SCREENWIDTH * 2, SCREENHEIGHT * 2, G_MAXZ / 2, 0,
	SCREENWIDTH * 2, SCREENHEIGHT * 2, G_MAXZ / 2, 0,
};

Lights1 AmbientLight    = gdSPDefLights1(0x80, 0x00, 0x00, 0xff, 0xff, 0xff,
    0x00, 0x00, 90);
Lights1 thelight        = gdSPDefLights1(0x40, 0x40, 0x40, 0xff, 0xff, 0xff,
    0x00, 0x00, 90);

Gfx Initialize[] =
{
 	gsSPViewport(&ViewPort),
    gsSPClearGeometryMode(G_SHADE | G_LIGHTING | G_SHADING_SMOOTH | G_ZBUFFER
        | G_TEXTURE_GEN | G_TEXTURE_GEN_LINEAR | G_CULL_BOTH | G_FOG),
	gsSPTexture(0, 0, 0, 0, G_OFF),
	gsSPClipRatio(FRUSTRATIO_2),
	gsDPSetCycleType(G_CYC_1CYCLE),
	gsDPPipelineMode(G_PM_NPRIMITIVE),
	gsDPSetScissor(G_SC_NON_INTERLACE, 0, 0, SCREENWIDTH, SCREENHEIGHT),
    gsDPSetTextureLOD(G_TL_TILE),
	gsDPSetTextureLUT(G_TT_NONE),
	gsDPSetTextureDetail(G_TD_CLAMP),
	gsDPSetTexturePersp(G_TP_PERSP),
	gsDPSetTextureFilter(G_TF_BILERP),
	gsDPSetTextureConvert(G_TC_FILT),
	gsSPSetLights1(AmbientLight),
	gsDPSetCombineMode(G_CC_SHADE, G_CC_SHADE),
	gsDPSetCombineKey(G_CK_NONE),
	gsDPSetAlphaCompare(G_AC_NONE),
	gsDPSetRenderMode(G_RM_AA_OPA_SURF, G_RM_AA_OPA_SURF2),
	gsDPSetColorDither(G_CD_BAYER),
	gsDPSetAlphaDither(G_AD_NOISE),
	gsDPPipeSync(),
	gsSPEndDisplayList()
};

Gfx ClearZBuffer[] =
{
	gsDPSetScissor(G_SC_NON_INTERLACE, 0, 0, SCREENWIDTH, SCREENHEIGHT),
	gsDPSetDepthImage(OS_K0_TO_PHYSICAL(ZBuffer)),
	gsDPSetCycleType(G_CYC_FILL),
	gsDPSetColorImage(G_IM_FMT_RGBA, G_IM_SIZ_16b, SCREENWIDTH, OS_K0_TO_PHYSICAL(ZBuffer)),
	gsDPSetFillColor(GPACK_ZDZ(G_MAXFBZ, 0) << 16 | GPACK_ZDZ(G_MAXFBZ, 0)),
	gsDPFillRectangle(0, 0, SCREENWIDTH - 1, SCREENHEIGHT - 1),
	gsDPPipeSync(),
	gsSPEndDisplayList()
};

Gfx CheckInit[] =
{
 	gsSPViewport(&ViewPort),
    gsSPClearGeometryMode(G_SHADE | G_LIGHTING | G_SHADING_SMOOTH | G_ZBUFFER
        | G_TEXTURE_GEN | G_TEXTURE_GEN_LINEAR | G_CULL_BOTH | G_FOG),
	gsSPTexture(0, 0, 0, 0, G_OFF),
	gsSPClipRatio(FRUSTRATIO_2),
	gsDPSetCycleType(G_CYC_1CYCLE),
	gsDPPipelineMode(G_PM_NPRIMITIVE),
	gsDPSetScissor(G_SC_NON_INTERLACE, 0, 0, SCREENWIDTH, SCREENHEIGHT),
    gsDPSetTextureLOD(G_TL_TILE),
	gsDPSetTextureLUT(G_TT_NONE),
	gsDPSetTextureDetail(G_TD_CLAMP),
	gsDPSetTexturePersp(G_TP_PERSP),
	gsDPSetTextureFilter(G_TF_BILERP),
	gsDPSetTextureConvert(G_TC_FILT),
    gsSPSetLights1(thelight),
	gsDPSetCombineMode(G_CC_SHADE, G_CC_SHADE),
	gsDPSetCombineKey(G_CK_NONE),
	gsDPSetAlphaCompare(G_AC_NONE),
	gsDPSetRenderMode(G_RM_AA_OPA_SURF, G_RM_AA_OPA_SURF2),
	gsDPSetColorDither(G_CD_BAYER),
	gsDPSetAlphaDither(G_AD_NOISE),
	gsDPPipeSync(),
	gsSPEndDisplayList()
};

Gfx ClearRenderBuffer[] =
{
	gsDPSetCycleType(G_CYC_FILL),
	gsDPSetFillColor(GPACK_RGBA5551(0, 0, 0, 1) << 16 |	GPACK_RGBA5551(0, 0, 0, 1)),
	gsDPFillRectangle(0, 0, SCREENWIDTH - 1, SCREENHEIGHT - 1),
    gsDPPipeSync(),
	gsSPEndDisplayList()
};


