// **************************************************************************
// *				Sporting Clays for the Nintendo 64						*
// *					   (C) 1999 Charles Doty                           	*
// *	     Sprite Header file contains sprite definition code				*
// **************************************************************************

#include <ultra64.h>

#include "defines.h"
#include "levels\levels.h"
#include "data\mouse.h"
#include "data\shot.h"

extern Bitmap Font[49];

Gfx BackgroundGfx[NUM_DL(BACKGROUNDBLOCKS)];

Sprite BackgroundImage =
{
 	0, 0,					// position: x,y
 	320, 240,				// sprite size in texels: x,y
 	1.0, 1.0,				// sprite scale: x,y
 	0, 0,					// explosion: x,y
 	SP_TRANSPARENT,			// attribute:
 	0x1234,					// sprite depth: z
 	255, 255, 255, 255,		// sprite coloration RGBA
 	0, 0, NULL,				// color lookup table: start_index, length, address
 	0, 1,					// sprite bitmap index: start_index, increment
 	BACKGROUNDBLOCKS,		// number of bitmaps
 	NUM_DL(BACKGROUNDBLOCKS),// number of dl locations allocated
 	40, 40,					// width and height of graphics block
 	G_IM_FMT_RGBA,			// sprite bitmap format
 	G_IM_SIZ_16b,			// sprite bitmap texel size
    Levels[0],              // pointer to bitmaps
 	BackgroundGfx,			// rsp_dl: display list memory
 	NULL,					// rsp_next_dl: dynamic_dl pointer
 	0, 0					// texture fractional offsets
};

Gfx TextGfx[300][NUM_DL(1)];

Sprite TextImage[300] =
{
 	0, 0,					// position: x,y
    FONTSIZE, FONTSIZE,     // sprite size in texels: x,y
 	1.0, 1.0,				// sprite scale: x,y
 	0, 0,					// explosion: x,y
    SP_TRANSPARENT | SP_CUTOUT,// attribute:
 	0x1234,					// sprite depth: z
 	255, 255, 255, 255,		// sprite coloration RGBA
 	0, 0, NULL,				// color lookup table: start_index, length, address
 	0, 1,					// sprite bitmap index: start_index, increment
 	1,						// number of bitmaps
 	NUM_DL(1),				// number of dl locations allocated
    FONTSIZE, FONTSIZE,     // width and height of graphics block
 	G_IM_FMT_RGBA,			// sprite bitmap format
 	G_IM_SIZ_16b,			// sprite bitmap texel size
    &Font[0],               // pointer to bitmaps
 	TextGfx[0],				// rsp_dl: display list memory
 	NULL,					// rsp_next_dl: dynamic_dl pointer
 	0, 0					// texture fractional offsets
};

Gfx MouseGfx[NUM_DL(1)];

Sprite MouseImage =
{
 	0, 0,					// position: x,y
 	MOUSESIZE, MOUSESIZE,	// sprite size in texels: x,y
 	1.0, 1.0,				// sprite scale: x,y
 	0, 0,					// explosion: x,y
    SP_TRANSPARENT | SP_CUTOUT,// attribute:
 	0x1234,					// sprite depth: z
 	255, 255, 255, 255,		// sprite coloration RGBA
 	0, 0, NULL,				// color lookup table: start_index, length, address
 	0, 1,					// sprite bitmap index: start_index, increment
 	1,						// number of bitmaps
 	NUM_DL(1),				// number of dl locations allocated
 	MOUSESIZE, MOUSESIZE,	// width and height of graphics block
 	G_IM_FMT_RGBA,			// sprite bitmap format
 	G_IM_SIZ_16b,			// sprite bitmap texel size
 	mouse_bitmap,			// pointer to bitmaps
 	MouseGfx,				// rsp_dl: display list memory
 	NULL,					// rsp_next_dl: dynamic_dl pointer
 	0, 0					// texture fractional offsets
};

Gfx  	ShotsGfx[MAXSHOTS][NUM_DL(1)];

Sprite 	ShotsImage[MAXSHOTS] =
{
	{
 		0, 0,					// position: x,y
 		SHOTSIZE, SHOTSIZE,		// sprite size in texels: x,y
 		1.0, 1.0,				// sprite scale: x,y
 		0, 0,					// explosion: x,y
 		SP_TRANSPARENT | SP_CUTOUT,// attribute:
 		0x1234,					// sprite depth: z
 		255, 255, 255, 255,		// sprite coloration RGBA
 		0, 0, NULL,				// color lookup table: start_index, length, address
 		0, 1,					// sprite bitmap index: start_index, increment
 		1,						// number of bitmaps
 		NUM_DL(1),				// number of dl locations allocated
 		SHOTSIZE, SHOTSIZE,		// width and height of graphics block
 		G_IM_FMT_RGBA,			// sprite bitmap format
 		G_IM_SIZ_16b,			// sprite bitmap texel size
 		shot_bitmap,			// pointer to bitmaps
 		ShotsGfx[0],			// rsp_dl: display list memory
 		NULL,					// rsp_next_dl: dynamic_dl pointer
 		0, 0					// texture fractional offsets
	},

	{
 		0, 0,					// position: x,y
 		SHOTSIZE, SHOTSIZE,		// sprite size in texels: x,y
 		1.0, 1.0,				// sprite scale: x,y
 		0, 0,					// explosion: x,y
 		SP_TRANSPARENT | SP_CUTOUT,// attribute:
 		0x1234,					// sprite depth: z
 		255, 255, 255, 255,		// sprite coloration RGBA
 		0, 0, NULL,				// color lookup table: start_index, length, address
 		0, 1,					// sprite bitmap index: start_index, increment
 		1,						// number of bitmaps
 		NUM_DL(1),				// number of dl locations allocated
 		SHOTSIZE, SHOTSIZE,		// width and height of graphics block
 		G_IM_FMT_RGBA,			// sprite bitmap format
 		G_IM_SIZ_16b,			// sprite bitmap texel size
 		shot_bitmap,			// pointer to bitmaps
 		ShotsGfx[1],			// rsp_dl: display list memory
 		NULL,					// rsp_next_dl: dynamic_dl pointer
 		0, 0					// texture fractional offsets
	}
};
