// **************************************************************************
// *				Sporting Clays for the Nintendo 64						*
// *					   (C) 1999 Charles Doty                           	*
// *	 	    Math Header file contains math related code					*
// **************************************************************************

#include <ultra64.h>

#include "math.h"

void AngleVectors(vector *angles, vector *out)
{
	float angle;
	float sr, sp, sy, cr, cp, cy;

	angle 	= angles->y * (M_PI * 2 / 360);
	sr 		= sinf(angle);
	cr 		= cosf(angle);
	angle 	= angles->z * (M_PI * 2 / 360);
	sp 		= sinf(angle);
	cp 		= cosf(angle);

	out->x 	= cp * cr;
	out->y 	= sp * cr;
	out->z 	= -sr;
}
