// Debug module routines

// Memory Map
// ----------
//
// b1ff0000 - b1ffffef
//   putchar buffer
//
// b1fffff0 - Current putchar buffer position
//
// b1fffff4 - Wrap-around flag
//      0 = no wrap. start of data is PUTCHAR_BUF_START.
//      1 = wrap. start of data is *PUTCHAR_BUF_POS.
//

// Putchar buffer start location & lenght.
//  (Actual length is PUTCHAR_BUF_LENGTH/4.
//   PI memory is too slow so we don't
//   want to try to pack 1 byte per address.
//   It is faster to store 1 byte every
//   4 address locations since we don't
//   have to read/mask/write to do this.)
//
// NOTE: Length must be increments of 4.


#define PUTCHAR_BUF_START   0xb1ff0000
#define PUTCHAR_BUF_LENGTH  0x0000fff0

#define PUTCHAR_BUF_POS     0xb1fffff0  //0xb1fffef8
#define PUTCHAR_FLAG        0xb1fffff4  //0xb1fffefc

 // Global variables
 unsigned long putcharPtr;

 // Routines

#include "writepi.c"

#include "putchar.c"

#include "printf.c"


void InitPrintf (void)
   {
   int i;

   // Clear debug memory area
   for (i=0; i<16384; i++)
      WritePI ( PUTCHAR_BUF_START + (i*4), 0 );

   // Turn wrap around flag off
   WritePI ( PUTCHAR_FLAG , 0 );

   // Set putchar output storage address
   putcharPtr = PUTCHAR_BUF_START;

   }

