// **********************************************************************************************
// *								  3D Engine													*
// **********************************************************************************************

#ifndef __MESHP3D_H
#define __MESHP3D_H

#include "Mesh3D.h"

class TMeshP3D : public TMesh3D
{
  protected:
	tagPFace		*Faces;				// Faces

  public:
	TMeshP3D();
	  // Constructor

	~TMeshP3D();
	  // Destructor

	virtual DWORD Initialize();
	  // Initialize the mesh

	virtual DWORD Close();
	  // Close the mesh

	virtual DWORD Cull(TFrustum *Frustum);
	  // Cull the mesh if needed

	virtual DWORD Animate();
	  // Animate the mesh if not culled

	virtual DWORD Render(TCamera *Camera);
	  // Render the mesh if not culled

	virtual DWORD GetSortZ();
	  // Get the position of the object in the scene

	virtual BOOL FindName(char *MeshName);
	  // Find object name

	virtual BOOL FindPosition(char *MeshName, TVertex *MeshPosition);
	  // Find object position based on name

	virtual DWORD SetName(char *NewName);
	  // Set object name

	virtual DWORD EnableAnimation();
	  // Enable animation

	virtual DWORD DisableAnimation();
	  // Disable animation

	virtual DWORD GetAnimationLength();
	  // Get animation length
	    
	virtual DWORD SetAnimationFrames(DWORD NewStartFrame, DWORD NewEndFrame);
	  // Set start and end frames for an animation

	virtual DWORD SetAnimationType(DWORD NewType);
	  // Set start and end frames for an animation

	virtual DWORD SetAnimationSpeed(float NewRate);
	  // Set animation speed

	virtual DWORD GetPosition(TVertex *WorldPosition);
	  // Get position

	virtual DWORD SetPosition(TVertex *WorldPosition);
	  // Set position

	virtual DWORD GetRotation(TVertex *Rotation);
	  // Get rotation

	virtual DWORD SetRotation(TVertex *Rotation);
	  // Set rotation

	virtual DWORD GetBoundingSphere(tagBSphere *Sphere);
	  // Gets the bounding sphere of an object

	virtual DWORD GetMinimum(TVertex *MinimumVertex);
	  // Get minimum

	virtual DWORD GetMaximum(TVertex *MaximumVertex);
	  // Get maximum

	virtual DWORD Select();
	  // Selects a mesh

	virtual DWORD Deselect();
	  // Deselects a mesh

	virtual BOOL PointInMesh(TVertex *Point);
	  // Point in mesh?

	virtual DWORD Load(BYTE **Buffer, DWORD TextureStart);
	  // Load a mesh from a mesh list entry
};

#endif