// **********************************************************************************************
// *								  3D Engine													*
// **********************************************************************************************

#include "MeshP3D.h"
#include "..\Utility\Utility.h"
#include "..\Include.h"

TMeshP3D::TMeshP3D()
{
}

TMeshP3D::~TMeshP3D()
{
	Close();
}

DWORD TMeshP3D::Initialize()
{
	return	TMesh3D::Initialize();
}

DWORD TMeshP3D::Close()
{
	return	TMesh3D::Close();
}

DWORD TMeshP3D::Cull(TFrustum *Frustum)
{
	return	TMesh3D::Cull(Frustum);
}

DWORD TMeshP3D::Animate()
{
	if (TRUE == Culled || FALSE == Animating)
	{
		return	ERR_NOERROR;
	}

	return	ERR_NOERROR;
}

DWORD TMeshP3D::Render(TCamera *Camera)
{
	if (TRUE == Culled)
	{
		return	ERR_NOERROR;
	}

	if (TRUE == Faces[0].Lit)
	{
		glEnable(GL_LIGHTING);
	}

	else
	{
		glDisable(GL_LIGHTING);
	}

	for (DWORD Loop = 0; Loop < NumFaces; Loop++)
	{
		tagPFace	Face	= Faces[Loop];

		if (TRUE == Camera->GetEditMode() || TRUE == Face.TwoSided)
		{
			glDisable(GL_CULL_FACE);
		}

		else
		{
			glEnable(GL_CULL_FACE);
		}

		if (Scene3D != NULL)
		{
			UINT	TextureID	= Scene3D->GetTexture(Face.TextureIndex);

			if (TextureID != -1)
			{
				glBindTexture(GL_TEXTURE_2D, TextureID);
			}
		}

		if (4 == Face.NumVertices)
		{
			glBegin(GL_QUADS);
		}

		else
		{
			glBegin(GL_TRIANGLES);
		}

		// Vertex 1
		glNormal3f(Normals[Face.VertexIndex1].x, Normals[Face.VertexIndex1].y, 
			Normals[Face.VertexIndex1].z);

		glTexCoord2f(UVs[Face.TextureIndex1].u, UVs[Face.TextureIndex1].v); 

		glVertex3f(Vertices[Face.VertexIndex1].x, Vertices[Face.VertexIndex1].y, 
			Vertices[Face.VertexIndex1].z);

		// Vertex 2
		glNormal3f(Normals[Face.VertexIndex2].x, Normals[Face.VertexIndex2].y, 
			Normals[Face.VertexIndex2].z);

		glTexCoord2f(UVs[Face.TextureIndex2].u, UVs[Face.TextureIndex2].v); 

		glVertex3f(Vertices[Face.VertexIndex2].x, Vertices[Face.VertexIndex2].y, 
			Vertices[Face.VertexIndex2].z);

		// Vertex 3
		glNormal3f(Normals[Face.VertexIndex3].x, Normals[Face.VertexIndex3].y, 
			Normals[Face.VertexIndex3].z);

		glTexCoord2f(UVs[Face.TextureIndex3].u, UVs[Face.TextureIndex3].v); 

		glVertex3f(Vertices[Face.VertexIndex3].x, Vertices[Face.VertexIndex3].y, 
			Vertices[Face.VertexIndex3].z);

		if (4 == Face.NumVertices)
		{
			// Vertex 4
			glNormal3f(Normals[Face.VertexIndex4].x, Normals[Face.VertexIndex4].y, 
				Normals[Face.VertexIndex4].z);

			glTexCoord2f(UVs[Face.TextureIndex4].u, UVs[Face.TextureIndex4].v); 

			glVertex3f(Vertices[Face.VertexIndex4].x, Vertices[Face.VertexIndex4].y, 
				Vertices[Face.VertexIndex4].z);
		}

		glEnd();
	}

	glEnable(GL_CULL_FACE);

	return	ERR_NOERROR;
}

DWORD TMeshP3D::GetSortZ()
{
	return	TMesh3D::GetSortZ();
}

BOOL TMeshP3D::FindName(char *MeshName)
{
	return	TMesh3D::FindName(MeshName);
}

BOOL TMeshP3D::FindPosition(char *MeshName, TVertex *MeshPosition)
{
	return	TMesh3D::FindPosition(MeshName, MeshPosition);
}

DWORD TMeshP3D::SetName(char *NewName)
{
	return	TMesh3D::SetName(NewName);
}

DWORD TMeshP3D::EnableAnimation()
{
	return	TMesh3D::EnableAnimation();
}

DWORD TMeshP3D::DisableAnimation()
{
	return	TMesh3D::DisableAnimation();
}

DWORD TMeshP3D::GetAnimationLength()
{
	return	TMesh3D::GetAnimationLength();
}
	    
DWORD TMeshP3D::SetAnimationFrames(DWORD NewStartFrame, DWORD NewEndFrame)
{
	return	TMesh3D::SetAnimationFrames(NewStartFrame, NewEndFrame);
}

DWORD TMeshP3D::SetAnimationType(DWORD NewType)
{
	return	TMesh3D::SetAnimationType(NewType);
}

DWORD TMeshP3D::SetAnimationSpeed(float NewRate)
{
	return	TMesh3D::SetAnimationSpeed(NewRate);
}

DWORD TMeshP3D::GetPosition(TVertex *WorldPosition)
{
	return	TMesh3D::GetPosition(WorldPosition);
}

DWORD TMeshP3D::SetPosition(TVertex *WorldPosition)
{
	return	TMesh3D::SetPosition(WorldPosition);
}

DWORD TMeshP3D::GetRotation(TVertex *Rotation)
{
	return	TMesh3D::GetRotation(Rotation);
}

DWORD TMeshP3D::SetRotation(TVertex *Rotation)
{
	return	TMesh3D::SetRotation(Rotation);
}

DWORD TMeshP3D::GetBoundingSphere(tagBSphere *Sphere)
{
	return	TMesh3D::GetBoundingSphere(Sphere);
}

DWORD TMeshP3D::GetMinimum(TVertex *MinimumVertex)
{
	return	TMesh3D::GetMinimum(MinimumVertex);
}

DWORD TMeshP3D::GetMaximum(TVertex *MaximumVertex)
{
	return	TMesh3D::GetMaximum(MaximumVertex);
}

DWORD TMeshP3D::Select()
{
	return	TMesh3D::Select();
}

DWORD TMeshP3D::Deselect()
{
	return	TMesh3D::Deselect();
}

BOOL TMeshP3D::PointInMesh(TVertex *Point)
{
	return	TMesh3D::PointInMesh(Point);
}

DWORD TMeshP3D::Load(BYTE **Buffer, DWORD TextureStart)
{
	// Read name
	memcpy(Name, *Buffer, 128);
	*Buffer	+= 128;

	// Read minimum
	memcpy(&Minimum, *Buffer, sizeof(TVertex));
	*Buffer	+= sizeof(TVertex);
		
	// Read maximum
	memcpy(&Maximum, *Buffer, sizeof(TVertex));
	*Buffer	+= sizeof(TVertex);
		
	// Read position
	memcpy(&OffsetPosition, *Buffer, sizeof(TVertex));
	*Buffer	+= sizeof(TVertex);
		
	Position	= OffsetPosition;

	// Read rotation
	memcpy(&Rotation, *Buffer, sizeof(TQuaternion));
	*Buffer	+= sizeof(TQuaternion);
		
	// Read number of vertices
	memcpy(&NumVertices, *Buffer, sizeof(DWORD));
	*Buffer	+= sizeof(DWORD);
		
	// Allocate memory for vertices
	Vertices	= new TVertex[NumVertices];

	if (NULL == Vertices)
	{
		return	ERR_MEMORYERROR;
	}

	// Read vertices
	memcpy(Vertices, *Buffer, sizeof(TVertex) * NumVertices);
	*Buffer	+= sizeof(TVertex) * NumVertices;

	// Read number of normals
	memcpy(&NumNormals, *Buffer, sizeof(DWORD));
	*Buffer	+= sizeof(DWORD);
		
	// Allocate memory for normals
	Normals	= new TVertex[NumVertices];

	if (NULL == Normals)
	{
		return	ERR_MEMORYERROR;
	}

	// Read normals
	memcpy(Normals, *Buffer, sizeof(TVertex) * NumVertices);
	*Buffer	+= sizeof(TVertex) * NumVertices;

	// Read number of texture coordinates
	memcpy(&NumUVs, *Buffer, sizeof(DWORD));
	*Buffer	+= sizeof(DWORD);
		
	// Allocate memory for texture coordinates
	UVs		= new tagUV[NumUVs];

	if (NULL == UVs)
	{
		return	ERR_MEMORYERROR;
	}

	// Read texture coordinates
	memcpy(UVs, *Buffer, sizeof(tagUV) * NumUVs);
	*Buffer	+= sizeof(tagUV) * NumUVs;

	// Read bounding sphere
	memcpy(&BoundSphere, *Buffer, sizeof(tagBSphere));
	*Buffer	+= sizeof(tagBSphere);

	// Read number of faces
	memcpy(&NumFaces, *Buffer, sizeof(DWORD));
	*Buffer	+= sizeof(DWORD);
		
	// Allocate memory for faces
	Faces	= new tagPFace[NumFaces];

	if (NULL == Faces)
	{
		return	ERR_MEMORYERROR;
	}

	// Read faces
	for (DWORD Loop = 0; Loop < NumFaces; Loop++)
	{
		memcpy(&Faces[Loop], *Buffer, sizeof(tagPFace));
		*Buffer	+= sizeof(tagPFace);
	
		Faces[Loop].TextureIndex	+= TextureStart;
	}

	// Read number of animations
	memcpy(&NumAnimations, *Buffer, sizeof(DWORD));
	*Buffer	+= sizeof(DWORD);
		
	if (NumAnimations > 0)
	{
		// Allocate memory for animations
		Animations	= new tagAnimation[NumAnimations];

		if (NULL == Animations)
		{
			return	ERR_MEMORYERROR;
		}

		// Read animations
		memcpy(Animations, *Buffer, sizeof(tagAnimation) * NumAnimations);
		*Buffer	+= sizeof(tagAnimation) * NumAnimations;
	}

	return	ERR_NOERROR;
}